/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

public class CreateEbeneCommand
extends Command {
    private final Darstellung darstellung;
    private Ebene ebene;

    public CreateEbeneCommand(Darstellung darstellung) {
        Assert.isNotNull((Object)darstellung, (String)"darstellung");
        this.darstellung = darstellung;
        this.setLabel("Neue Ebene anlegen");
    }

    public void execute() {
        this.ebene = this.createEbene();
        this.redo();
    }

    private Ebene createEbene() {
        Ebene e = this.darstellung.createEbene();
        Object name = "Ebene";
        if (!this.darstellung.getEbenen().isEmpty()) {
            name = this.darstellung.getEbenen().size() + 1 + ". " + (String)name;
        }
        e.setName((String)name);
        return e;
    }

    public void redo() {
        this.darstellung.getEbenen().add((Object)this.ebene);
    }

    public boolean canUndo() {
        return this.darstellung.getEbenen().size() > 1;
    }

    public void undo() {
        this.darstellung.getEbenen().remove((Object)this.ebene);
    }
}

