/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class DisableAutoVerwaltungCommand
extends Command {
    private final Collection<DoModel> model;
    private final AutoEbene ebene;
    private Darstellung darstellung;

    public DisableAutoVerwaltungCommand(Collection<DoModel> model, AutoEbene ebene) {
        Assert.isNotNull(model, (String)"model");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.model = model;
        this.ebene = ebene;
        this.setLabel("Automatische Verwaltung ausschalten");
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
        Assert.isNotNull((Object)this.darstellung, (String)"darstellung");
        Assert.isLegal((boolean)(this.darstellung instanceof MassstaeblicheDarstellung), (String)"Darstellung muss eine ma\u00dfst\u00e4blich Darstellung sein");
        this.redo();
    }

    public boolean canExecute() {
        for (DoModel m : this.model) {
            if (!this.ebene.isAutomatischVerwaltbar(m)) continue;
            return true;
        }
        return false;
    }

    public void redo() {
        this.ebene.getDoObjekte().addAll(this.model);
        ArrayList<SystemObject> sysObjekte = new ArrayList<SystemObject>();
        for (DoModel m : this.model) {
            sysObjekte.add(m.getSystemObject());
        }
        this.ebene.getSystemObjectsExcludes().addAll(sysObjekte);
    }

    public void undo() {
        this.ebene.getDoObjekte().removeAll(this.model);
        ArrayList<SystemObject> sysObjekte = new ArrayList<SystemObject>();
        for (DoModel m : this.model) {
            sysObjekte.add(m.getSystemObject());
        }
        this.ebene.getSystemObjectsExcludes().removeAll(sysObjekte);
    }
}

