/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.commands.CommandUtil;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class RemoveDoTypFromAutoEbeneCommand
extends Command {
    private final AutoEbene ebene;
    private final DoTyp doTyp;
    private int doTypIndexInEbene;
    private boolean removeDoTypFromDarstellung;

    public RemoveDoTypFromAutoEbeneCommand(DoTyp doTyp, AutoEbene ebene) {
        Assert.isNotNull((Object)doTyp, (String)"doTyp");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.doTyp = doTyp;
        this.ebene = ebene;
        this.setLabel("Darstellungsobjekttyp aus Autoebene entfernen");
    }

    public void execute() {
        this.removeDoTypFromDarstellung = !this.isNeededDoTyp();
        this.doTypIndexInEbene = this.getIndexInEbene(this.ebene);
        this.redo();
    }

    private int getIndexInEbene(AutoEbene e) {
        return e.getDoTypen().indexOf((Object)this.doTyp);
    }

    private boolean isNeededDoTyp() {
        Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
        return CommandUtil.isUsedDoTypInDarstellung(this.doTyp, darstellung, this.ebene);
    }

    public void redo() {
        this.ebene.getDoTypen().remove(this.doTypIndexInEbene);
        if (this.removeDoTypFromDarstellung) {
            Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
            darstellung.getDoTypen().remove((Object)this.doTyp);
        }
    }

    public void undo() {
        this.ebene.getDoTypen().add(this.doTypIndexInEbene, (Object)this.doTyp);
        if (this.removeDoTypFromDarstellung) {
            Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
            darstellung.getDoTypen().add((Object)this.doTyp);
        }
    }
}

