/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;

public class AusschnittAnlegenDialog
extends InputDialog {
    private static final String ERROR_TEXT_LEER = "Der Name f\u00fcr den Ausschnitt darf nicht leer sein";
    private static final String WARNUNG_TEXT_OVERWRITE = "Der Ausschnit existiert bereits und wird \u00fcberschrieben!";

    public AusschnittAnlegenDialog(Ansicht ansicht) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Ausschnitt speichern", "Geben Sie einen Namen f\u00fcr den zu speichernden Ausschnitt an!", "", newText -> {
            String result = null;
            String newName = newText.trim();
            if (newName.isEmpty()) {
                result = ERROR_TEXT_LEER;
            } else if (ansicht != null) {
                for (Ausschnitt ausschnitt : ansicht.getAusschnitte()) {
                    if (!ausschnitt.getName().equals(newName)) continue;
                    result = WARNUNG_TEXT_OVERWRITE;
                }
            }
            return result;
        });
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
        if (WARNUNG_TEXT_OVERWRITE.equals(errorMessage)) {
            this.getOkButton().setEnabled(true);
        }
    }
}

