/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import com.bitctrl.lib.eclipse.dialogs.ToolWindow;
import com.bitctrl.lib.eclipse.draw2d.parts.ScrollableThumbnail2;
import com.bitctrl.lib.eclipse.draw2d.parts.Thumbnail2;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class OverviewWindow
extends ToolWindow {
    private Canvas overview;
    private Thumbnail2 thumbnail;
    private DisposeListener disposeListener;

    public OverviewWindow(IWorkbenchPart part, Control partControl) {
        super(part, partControl);
        this.setCorner(ToolWindow.Corner.BottomRight);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        if (this.getGraphicalViewer() != null) {
            this.createThumbnail(container);
        } else {
            Label label = new Label(container, 64);
            label.setText("\u00dcbersicht nicht verf\u00fcgbar.");
            label.setBackground(parent.getDisplay().getSystemColor(1));
        }
        return container;
    }

    private Darstellung getDarstellung() {
        Darstellung result = (Darstellung)this.getWorkbenchPart().getAdapter(Darstellung.class);
        if (result == null) {
            result = (Darstellung)Platform.getAdapterManager().getAdapter((Object)this.getWorkbenchPart(), Darstellung.class);
        }
        return result;
    }

    private void createThumbnail(Composite container) {
        this.overview = new Canvas(container, 0);
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.getGraphicalViewer().getRootEditPart();
        if (rep instanceof ScalableRootEditPart) {
            ScalableRootEditPart root = (ScalableRootEditPart)rep;
            int maxBufferSize = this.getDarstellung() instanceof MassstaeblicheDarstellung ? 1000000 : 25600;
            this.thumbnail = new ScrollableThumbnail2(maxBufferSize, (Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = e -> {
                if (this.thumbnail != null) {
                    this.thumbnail.deactivate();
                    this.thumbnail = null;
                }
            };
            this.getEditor().addDisposeListener(this.disposeListener);
        }
    }

    private GraphicalViewer getGraphicalViewer() {
        GraphicalViewer result = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        if (result == null) {
            result = (GraphicalViewer)Platform.getAdapterManager().getAdapter((Object)this.getWorkbenchPart(), GraphicalViewer.class);
        }
        return result;
    }

    private FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    public boolean close() {
        if (this.disposeListener != null && this.getEditor() != null && !this.getEditor().isDisposed()) {
            this.getEditor().removeDisposeListener(this.disposeListener);
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u00dcbersicht");
        newShell.setSize(200, 200);
    }
}

