/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editors;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.actions.SelectAusschnittAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleEbenenAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleOverviewAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleSynchronizeSelectionAction;
import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DarstellungTreeEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.BerechtigungenBerechtigungsFunktion;
import de.bsvrz.buv.plugin.dobj.actions.EllipseSelectionAction;
import de.bsvrz.buv.plugin.dobj.actions.FixViewportAction;
import de.bsvrz.buv.plugin.dobj.actions.PolygonSelectionAction;
import de.bsvrz.buv.plugin.dobj.actions.RectangleSelectionAction;
import de.bsvrz.buv.plugin.dobj.actions.StreckeSelectionAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleAntiKollisionsAlgorithmusAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleBaustelleGueltigAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleSelectionFeedbackAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleTouchedSelectionAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleVerbindungslinieAction;
import de.bsvrz.buv.plugin.dobj.editors.DobjGraphicalEditor;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.dav.DefaultDavVerbindungsListener;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.legende.ILegende;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.buv.rw.basislib.legende.ITreeLegende;
import de.bsvrz.buv.rw.basislib.legende.LegendeWindow;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AnsichtEditor
extends DobjGraphicalEditor<Ansicht>
implements ITreeLegende,
RwPrintable {
    private static final String HILFE_ID = "de.bsvrz.buv.plugin.dobj." + AnsichtEditor.class.getSimpleName();
    public static final String EDITOR_ID = AnsichtEditor.class.getName();
    private final Adapter ebeneAdapter = new EbeneAdapter();
    private SpeicherKey einstellungsArt;
    private InternalDavVerbindungsListener davVerbindungsListener;

    public AnsichtEditor() {
        super(Ansicht.class);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Rahmenwerk rahmenWerk = RahmenwerkService.getService().getRahmenWerk();
        this.davVerbindungsListener = new InternalDavVerbindungsListener();
        rahmenWerk.addDavVerbindungsListener((DavVerbindungsListener)this.davVerbindungsListener);
        if (rahmenWerk.isOnline()) {
            this.geheOnline();
        }
    }

    public String getContributorId() {
        return "de.bsvrz.buv.plugin.darstellung.ansicht.propertyContributor";
    }

    @Override
    protected EditPartFactory getEditPartFactory() {
        return new DarstellungEditPartFactory();
    }

    @Override
    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.einstellungsArt = (SpeicherKey)input.getAdapter(SpeicherKey.class);
        Darstellung darstellung = ((Ansicht)this.getModel()).getDarstellung();
        for (Ebene ebene : darstellung.getEbenen()) {
            ebene.eAdapters().add((Object)this.ebeneAdapter);
        }
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new ToggleEbenenAction((IWorkbenchPart)this, this.getControl());
        registry.registerAction((IAction)action);
        action = new ToggleOverviewAction((IWorkbenchPart)this, this.getControl());
        registry.registerAction((IAction)action);
        action = new RectangleSelectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new EllipseSelectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new PolygonSelectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new StreckeSelectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ToggleSynchronizeSelectionAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ToggleVerbindungslinieAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ToggleBaustelleGueltigAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new FixViewportAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        SelectionProperties selectionProperties = new SelectionProperties();
        selectionProperties.getMatchDoTypen().addAll((Collection<DoTyp>)((Ansicht)this.getModel()).getDarstellung().getDoTypen());
        this.getGraphicalViewer().setProperty(SelectionProperties.class.toString(), (Object)selectionProperties);
        action = new ToggleTouchedSelectionAction(selectionProperties);
        registry.registerAction((IAction)action);
        action = new ToggleSelectionFeedbackAction(selectionProperties);
        registry.registerAction((IAction)action);
        action = new ToggleAntiKollisionsAlgorithmusAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new SelectAusschnittAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HILFE_ID);
    }

    @Override
    protected IContentOutlinePage getOutlinePage() {
        return new DobjGraphicalEditor.OutlinePage(this){
            {
                this.setMaxBufferSize(100000);
            }

            @Override
            protected EditPartFactory getEditPartFactory() {
                return new DarstellungTreeEditPartFactory();
            }
        };
    }

    public void doSave(IProgressMonitor monitor) {
        Ansicht ansicht = (Ansicht)this.getModel();
        IStatus status = EmfUtil.validate((EObject)ansicht, (String)"de.bsvrz.buv.plugin.dobj");
        if (status.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Ansicht kann nicht gespeichert werden.", (String)"Die zu speichernde Ansicht ist ung\u00fcltig und kann nicht gespeichert werden.", (IStatus)status);
            DObjPlugin.getDefault().getLog().log(status);
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Ansicht speichern...", (int)2);
        if (BerechtigungenBerechtigungsFunktion.ANSICHT_NETZWERKWEIT_SPEICHERN_OHNE_URLASSER.isFreigegeben()) {
            Rahmenwerk rw = RahmenwerkService.getService().getRahmenWerk();
            UrlasserInfo info = new UrlasserInfo(rw.getBenutzer(), rw.getPasswort(), "Speichern der Ansicht " + ansicht.getName(), "");
            try {
                AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(SpeicherKey.allgemeinNetzweit(), ansicht.getName(), ansicht, info);
                this.getCommandStack().markSaveLocation();
                subMonitor.worked(1);
            }
            catch (IOException ex) {
                subMonitor.setCanceled(true);
                String message = "Speichern einer Ansicht ist fehlgeschlagen.";
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Fehler", (String)"Speichern einer Ansicht ist fehlgeschlagen.");
            }
        } else {
            UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(this.getSite().getShell(), (verbindung, urlasser) -> {
                try {
                    AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(this.einstellungsArt, ansicht.getName(), ansicht, urlasser);
                    this.getCommandStack().markSaveLocation();
                }
                catch (IOException ex) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"FEHLER", (String)"Ansicht konnte nicht gesichert werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dobj", ex.getLocalizedMessage(), (Throwable)ex));
                }
            });
            dialog.open();
        }
        subMonitor.done();
    }

    public Control getControl() {
        return this.getGraphicalViewer().getControl().getParent();
    }

    public List<ILegendeBaustein> getBausteine() {
        return new ArrayList<ILegendeBaustein>(this.getBausteine((EditPart)this.getGraphicalViewer().getRootEditPart()).values());
    }

    private Map<DoTyp, ILegendeBaustein> getBausteine(EditPart editPart) {
        Ebene ebene;
        Object object;
        TreeMap<DoTyp, ILegendeBaustein> bausteine = new TreeMap<DoTyp, ILegendeBaustein>(Comparator.comparing(Named::getName));
        ILegendeBaustein baustein = (ILegendeBaustein)editPart.getAdapter(ILegendeBaustein.class);
        if (baustein == null) {
            baustein = (ILegendeBaustein)Platform.getAdapterManager().getAdapter((Object)editPart, ILegendeBaustein.class);
        }
        if ((object = editPart.getModel()) instanceof Ebene && !(ebene = (Ebene)object).isVisible()) {
            return Collections.emptyMap();
        }
        Object model = editPart.getModel();
        if (model instanceof DoModel) {
            DoModel doModel = (DoModel)model;
            DoTyp doTyp = doModel.getDoTyp();
            if (baustein != null && !bausteine.containsKey(doTyp)) {
                bausteine.put(doTyp, baustein);
            }
        }
        for (EditPart e : editPart.getChildren()) {
            bausteine.putAll(this.getBausteine(e));
        }
        return bausteine;
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == Darstellung.class) {
            return ((Ansicht)this.getModel()).getDarstellung();
        }
        return super.getAdapter(type);
    }

    public PagePrint getDruckAuftrag() {
        GridPrint grid = new GridPrint();
        grid.addColumn(new GridColumn(16384, -1, 0));
        Display d = this.getSite().getShell().getDisplay();
        GraphicalEditPart rootEditPart = (GraphicalEditPart)this.getGraphicalViewer().getRootEditPart();
        Rectangle swtR = new Rectangle(rootEditPart.getFigure().getBounds().x, rootEditPart.getFigure().getBounds().y, rootEditPart.getFigure().getBounds().width, rootEditPart.getFigure().getBounds().height);
        Image image = new Image((Device)d, swtR);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtg = new SWTGraphics(gc);
        rootEditPart.getFigure().paint((Graphics)swtg);
        swtg.dispose();
        gc.dispose();
        grid.add((Print)new ImagePrint(image.getImageData()));
        return new PagePrint((Print)new BigPrint((Print)grid));
    }

    public String getTitel() {
        return this.getPartName();
    }

    @Override
    public void dispose() {
        if (this.davVerbindungsListener != null) {
            RahmenwerkService.getService().getRahmenWerk().removeDavVerbindungsListener((DavVerbindungsListener)this.davVerbindungsListener);
        }
        Darstellung darstellung = ((Ansicht)this.getModel()).getDarstellung();
        for (Ebene ebene : darstellung.getEbenen()) {
            ebene.eAdapters().remove((Object)this.ebeneAdapter);
        }
        super.dispose();
    }

    public boolean isLegendeEnabled() {
        return ((Ansicht)this.getModel()).getDarstellung().isLegendeAktivieren();
    }

    public ILegende.Corner getDefaultCorner() {
        return ILegende.Corner.TopLeft;
    }

    private final class EbeneAdapter
    extends AdapterImpl {
        private EbeneAdapter() {
        }

        public void notifyChanged(Notification notification) {
            Object notifier = notification.getNotifier();
            int type = notification.getEventType();
            if (notifier instanceof Ebene) {
                LegendeWindow legendeWindow;
                int featureID = notification.getFeatureID(Ebene.class);
                if (1 == type && 1 == featureID && (legendeWindow = LegendeWindow.getCachedLegendeWindowFor((IWorkbenchPart)AnsichtEditor.this)) != null) {
                    legendeWindow.refresh();
                }
            }
        }
    }

    private final class InternalDavVerbindungsListener
    extends DefaultDavVerbindungsListener {
        private InternalDavVerbindungsListener() {
        }

        public void verbindungHergestellt(DavVerbindungsEvent event) {
            UIJob uiJob = new UIJob("Gehe online"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AnsichtEditor.this.geheOnline();
                    return Status.OK_STATUS;
                }
            };
            uiJob.schedule();
        }

        public void verbindungGetrennt(DavVerbindungsEvent event) {
            UIJob uiJob = new UIJob("Gehe offline"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AnsichtEditor.this.geheOffline();
                    return Status.OK_STATUS;
                }
            };
            uiJob.schedule();
        }
    }
}

