/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import de.bsvrz.buv.plugin.darstellung.editpolicies.AnsichtLayoutEditPolicy;
import de.bsvrz.buv.plugin.darstellung.figures.AnsichtFigure;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.dobj.editparts.BaseGraphicalEditPart;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class AnsichtEditPart
extends BaseGraphicalEditPart<Ansicht, AnsichtFigure> {
    protected List<?> getModelChildren() {
        return Collections.singletonList(((Ansicht)this.getModel()).getDarstellung());
    }

    protected AnsichtFigure createFigure() {
        return new AnsichtFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new AnsichtLayoutEditPolicy());
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        int type = notification.getEventType();
        if (notifier instanceof Ansicht) {
            int featureID = notification.getFeatureID(Ansicht.class);
            block0 : switch (type) {
                case 1: {
                    switch (featureID) {
                        case 2: {
                            this.refreshChildren();
                            break block0;
                        }
                        case 1: {
                            this.refreshVisuals();
                        }
                    }
                }
            }
        }
    }

    protected void refreshVisuals() {
        AnsichtFigure f = (AnsichtFigure)this.getFigure();
        Ausschnitt newAusschnitt = ((Ansicht)this.getModel()).getAusschnitt();
        if (newAusschnitt != f.getAusschnitt()) {
            f.setAusschnitt(newAusschnitt);
            this.gotoAusschnitt(newAusschnitt);
        }
    }

    private void gotoAusschnitt(Ausschnitt newAusschnitt) {
        if (newAusschnitt == null) {
            this.getZoomManager().setZoom(1.0 / this.getZoomManager().getUIMultiplier());
            this.getZoomManager().getViewport().setHorizontalLocation(0);
            this.getZoomManager().getViewport().setVerticalLocation(0);
        } else {
            this.getZoomManager().setZoom(newAusschnitt.getZoomLevel());
            this.getZoomManager().getViewport().setHorizontalLocation(newAusschnitt.getBounds().x);
            this.getZoomManager().getViewport().setVerticalLocation(newAusschnitt.getBounds().y);
        }
    }

    public void activate() {
        super.activate();
        this.gotoAusschnitt(((AnsichtFigure)this.getFigure()).getAusschnitt());
    }
}

