/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import de.bsvrz.buv.plugin.darstellung.editpolicies.DarstellungRootComponentEditPolicy;
import de.bsvrz.buv.plugin.darstellung.figures.DarstellungFigure;
import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.editparts.BaseGraphicalEditPart;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;

public abstract class DarstellungEditPart<T extends Darstellung>
extends BaseGraphicalEditPart<T, DarstellungFigure> {
    public void setParent(EditPart parent) {
        if (parent != null) {
            super.setParent(parent);
            this.getViewer().setProperty(Darstellung.class.toString(), (Object)this.getModel());
        } else {
            if (this.getParent() != null) {
                this.getViewer().setProperty(Darstellung.class.toString(), null);
            }
            super.setParent(null);
        }
    }

    protected List<Ebene> getModelChildren() {
        return ((Darstellung)this.getModel()).getEbenen();
    }

    protected DarstellungFigure createFigure() {
        return new DarstellungFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DarstellungRootComponentEditPolicy());
    }

    public void activate() {
        super.activate();
        this.updateZoomLevels();
        double zoom = 1.0 / this.getZoomManager().getUIMultiplier();
        this.getZoomManager().setZoom(zoom);
        if (this.isEditor()) {
            ((DarstellungFigure)this.getFigure()).setBorder((Border)new LineBorder(ColorConstants.gray, 1, 2));
            EList<Ebene> ebenen = ((Darstellung)this.getModel()).getEbenen();
            ((Ebene)ebenen.get(ebenen.size() - 1)).setEditable(true);
        }
    }

    public void notifyChanged(Notification notification) {
        int featureID;
        Object notifier = notification.getNotifier();
        int type = notification.getEventType();
        if (notifier instanceof Darstellung) {
            featureID = notification.getFeatureID(Darstellung.class);
            block0 : switch (type) {
                case 1: {
                    switch (featureID) {
                        case 0: 
                        case 1: {
                            this.refreshVisuals();
                            break block0;
                        }
                        case 5: {
                            this.updateZoomLevels();
                            break block0;
                        }
                        case 11: {
                            this.updateStoerfallverfahren();
                            break block0;
                        }
                        case 12: {
                            this.updateAnzeigeVerfahren();
                            break block0;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (featureID) {
                        case 3: {
                            this.refreshChildren();
                            break block0;
                        }
                        case 6: {
                            this.updateZoomLevels();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (notifier instanceof StilisierteDarstellung) {
            featureID = notification.getFeatureID(StilisierteDarstellung.class);
            block14 : switch (type) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (featureID) {
                        case 16: {
                            this.refreshChildren();
                            break block14;
                        }
                    }
                    break;
                }
            }
        }
    }

    private void updateAnzeigeVerfahren() {
        AnzeigeVerfahren anzeigeVerfahren = ((Darstellung)this.getModel()).getAnzeigeVerfahren();
        this.getViewer().setProperty(AnzeigeVerfahren.class.getName(), (Object)anzeigeVerfahren);
    }

    private void updateStoerfallverfahren() {
        String stoerfallverfahren = ((Darstellung)this.getModel()).getStoerfallverfahren();
        this.getViewer().setProperty("stoerfallVerfahren.aspect", (Object)this.getDav().getDataModel().getAspect(stoerfallverfahren));
    }

    private void updateZoomLevels() {
        this.getZoomManager().setUIMultiplier(((Darstellung)this.getModel()).getZoomSkalierung());
        EList<Double> zoomStufen = ((Darstellung)this.getModel()).getZoomStufen();
        double[] zoomLevels = new double[zoomStufen.size()];
        int i = 0;
        while (i < zoomLevels.length) {
            zoomLevels[i] = (Double)zoomStufen.get(i);
            ++i;
        }
        this.getZoomManager().setZoomLevels(zoomLevels);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DarstellungFigure f = (DarstellungFigure)this.getFigure();
        if (((Darstellung)this.getModel()).getSize() != null) {
            f.setDarstellungSize(((Darstellung)this.getModel()).getSize());
            f.revalidate();
        } else {
            f.setDarstellungSize(new Dimension(1000, 1000));
            f.revalidate();
        }
    }
}

