/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import com.bitctrl.lib.eclipse.draw2d.svg.SVGCache;
import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.editpolicies.EbeneEditPolicy;
import de.bsvrz.buv.plugin.darstellung.editpolicies.EbeneXYLayoutEditPolicy;
import de.bsvrz.buv.plugin.darstellung.figures.EbeneFigure;
import de.bsvrz.buv.plugin.darstellung.figures.SpaltenLayout;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.editparts.BaseGraphicalEditPart;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.requests.OnlineRequest;
import de.bsvrz.buv.plugin.dobj.util.BildManager;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.konfigurationsdaten.KdBild;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class EbeneEditPart
extends BaseGraphicalEditPart<Ebene, EbeneFigure> {
    private final boolean debug = DObjPlugin.getDefault().isDebugging();
    private boolean online;
    private Bild hintergrund;
    private ImageDescriptor hintergrundDesc;

    protected List<?> getModelChildren() {
        StilisierteDarstellung stilisierteDarstellung;
        Darstellung darstellung = DarstellungAdapter.getDarstellung(this.getModel());
        if (darstellung instanceof StilisierteDarstellung && !(stilisierteDarstellung = (StilisierteDarstellung)darstellung).getSpalten().isEmpty()) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll((Collection<Object>)((Ebene)this.getModel()).getEbenen());
            result.addAll((Collection<Object>)stilisierteDarstellung.getSpalten());
            return result;
        }
        ArrayList<Named> result = new ArrayList<Named>();
        result.addAll((Collection<Named>)((Ebene)this.getModel()).getDoObjekte());
        result.addAll((Collection<Named>)((Ebene)this.getModel()).getEbenen());
        return result;
    }

    protected EbeneFigure createFigure() {
        return new EbeneFigure();
    }

    public void activate() {
        super.activate();
        Darstellung darstellung = DarstellungAdapter.getDarstellung(this.getModel());
        if (darstellung instanceof StilisierteDarstellung) {
            darstellung.eAdapters().add((Object)this);
        }
    }

    public void deactivate() {
        Object object = this.getRoot().getContents().getModel();
        if (object instanceof StilisierteDarstellung) {
            StilisierteDarstellung stilisierteDarstellung = (StilisierteDarstellung)object;
            stilisierteDarstellung.eAdapters().remove((Object)this);
        }
        super.deactivate();
        ((EbeneFigure)this.getFigure()).setSvgCache(null);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EbeneEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EbeneXYLayoutEditPolicy());
    }

    public void performRequest(Request req) {
        super.performRequest(req);
        if ("Online".equals(req.getType())) {
            this.online = ((OnlineRequest)req).isOnline();
            if (this.debug) {
                DObjPlugin.getDefault().getLog().info("Ebene " + EmfUtil.getText((EObject)this.getModel()) + " ist jetzt " + (this.online ? "online" : "offline") + ".");
            }
        }
    }

    public void notifyChanged(Notification notification) {
        int featureID;
        Object notifier = notification.getNotifier();
        int type = notification.getEventType();
        if (notifier instanceof Ebene) {
            featureID = notification.getFeatureID(Ebene.class);
            block0 : switch (type) {
                case 1: {
                    switch (featureID) {
                        case 1: {
                            Map editPartRegistry = this.getViewer().getEditPartRegistry();
                            for (DoModel doModel : ((Ebene)this.getModel()).getDoObjekte()) {
                                EditPart editPart = (EditPart)editPartRegistry.get(doModel);
                                editPart.performRequest((Request)new OnlineRequest(this.online && ((Ebene)this.getModel()).isVisible()));
                            }
                        }
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.refreshVisuals();
                            break block0;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (featureID) {
                        case 8: 
                        case 9: {
                            this.refreshChildren();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (notifier instanceof Darstellung) {
            featureID = notification.getFeatureID(Darstellung.class);
            switch (type) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (featureID != 3) break;
                    this.refreshChildren();
                    break;
                }
            }
        }
        if (notifier instanceof StilisierteDarstellung) {
            featureID = notification.getFeatureID(StilisierteDarstellung.class);
            switch (type) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (featureID != 16) break;
                    this.refreshVisuals();
                    this.refreshChildren();
                    break;
                }
            }
        }
    }

    protected void refreshVisuals() {
        EbeneFigure f;
        block36: {
            f = (EbeneFigure)this.getFigure();
            f.setVisible(((Ebene)this.getModel()).isVisible());
            Darstellung darstellung = DarstellungAdapter.getDarstellung(this.getModel());
            if (darstellung instanceof StilisierteDarstellung) {
                StilisierteDarstellung stilisierteDarstellung = (StilisierteDarstellung)darstellung;
                LayoutManager layout = f.getLayoutManager();
                if (stilisierteDarstellung.getSpalten().isEmpty()) {
                    if (!(layout instanceof XYLayout)) {
                        f.setLayoutManager((LayoutManager)new XYLayout());
                    }
                } else {
                    if (!(layout instanceof SpaltenLayout)) {
                        f.setLayoutManager((LayoutManager)new SpaltenLayout());
                    }
                    ((SpaltenLayout)f.getLayoutManager()).setHeight(darstellung.getSize().height);
                }
            }
            Bild bild = ((Ebene)this.getModel()).getHintergrund();
            if (this.hintergrund == null || !this.hintergrund.equals(bild)) {
                this.hintergrund = bild;
                if (this.hintergrundDesc != null) {
                    this.getResourceManager().destroy((DeviceResourceDescriptor)this.hintergrundDesc);
                }
                if (bild != null) {
                    if ("image/svg+xml".equalsIgnoreCase(((KdBild.Daten)bild.getKdBild().getDatum()).getMIMEType())) {
                        Feld bilddaten = ((KdBild.Daten)bild.getKdBild().getDatum()).getBilddaten();
                        byte[] buffer = new byte[bilddaten.size()];
                        int i = 0;
                        while (i < bilddaten.size()) {
                            buffer[i] = ((AttByte_JavaKeyword)bilddaten.get(i)).byteValue();
                            ++i;
                        }
                        File file = null;
                        try {
                            try {
                                file = DObjPlugin.getDefault().getBundle().getBundleContext().getDataFile("hintergrund_svg" + System.currentTimeMillis() + ".tmp");
                                Throwable throwable = null;
                                Object var9_13 = null;
                                try (FileOutputStream fout = new FileOutputStream(file);){
                                    fout.write(buffer);
                                    fout.flush();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                SVGCache svg = new SVGCache();
                                svg.setURI(file.toURI().toString(), true);
                                f.setSvgCache(svg);
                            }
                            catch (IOException ex) {
                                DObjPlugin.getDefault().getLog().error("Laden eines SVG Hintergrundbildes ist fehlgeschlagen.", (Throwable)ex);
                                if (file != null) {
                                    try {
                                        Files.deleteIfExists(file.toPath());
                                    }
                                    catch (IOException ex2) {
                                        DObjPlugin.getDefault().getLog().error("Fehler beim L\u00f6schen der tempor\u00e4ren Datei!", (Throwable)ex2);
                                    }
                                }
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            if (file != null) {
                                try {
                                    Files.deleteIfExists(file.toPath());
                                }
                                catch (IOException ex) {
                                    DObjPlugin.getDefault().getLog().error("Fehler beim L\u00f6schen der tempor\u00e4ren Datei!", (Throwable)ex);
                                }
                            }
                            throw throwable;
                        }
                        if (file != null) {
                            try {
                                Files.deleteIfExists(file.toPath());
                            }
                            catch (IOException ex) {
                                DObjPlugin.getDefault().getLog().error("Fehler beim L\u00f6schen der tempor\u00e4ren Datei!", (Throwable)ex);
                            }
                        }
                    } else {
                        this.hintergrundDesc = BildManager.INSTANCE.getImageDescriptor(bild);
                        Image image = (Image)this.getResourceManager().create((DeviceResourceDescriptor)this.hintergrundDesc);
                        f.setHintergrund(image);
                    }
                } else {
                    f.setHintergrund(null);
                }
            }
        }
        f.setHintergrundSkalierung(((Ebene)this.getModel()).getHintergrundSkalierung());
        f.setHintergrundLocation(((Ebene)this.getModel()).getHintergrundLocation());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class && this.isEditor()) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.isEmpty()) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }
}

