/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPart;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.QuadratischePlattkarteProjektion;
import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;

public class MassstaeblicheDarstellungEditPart
extends DarstellungEditPart<MassstaeblicheDarstellung> {
    private QuadratischePlattkarteProjektion projektion;

    @Override
    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (parent != null) {
            this.getViewer().setProperty(KollisionsManager.class.toString(), (Object)new KollisionsManager());
            this.updateProjektion();
        }
    }

    private void updateProjektion() {
        this.projektion = new QuadratischePlattkarteProjektion();
        this.projektion.setDarstellung((Darstellung)this.getModel());
        this.getViewer().setProperty(Projektion.class.toString(), (Object)this.projektion);
        double nord = ((MassstaeblicheDarstellung)this.getModel()).getMaximaleGeographischeBreite();
        double sued = ((MassstaeblicheDarstellung)this.getModel()).getMinimaleGeographischeBreite();
        double west = ((MassstaeblicheDarstellung)this.getModel()).getMinimaleGeographischeLaenge();
        double ost = ((MassstaeblicheDarstellung)this.getModel()).getMaximaleGeographischeLaenge();
        Point obenLinks = this.projektion.umrechnenWeltNachModel((Point)new PrecisionPoint(west, nord));
        Point untenRechts = this.projektion.umrechnenWeltNachModel((Point)new PrecisionPoint(ost, sued));
        ((MassstaeblicheDarstellung)this.getModel()).setSize(new Dimension(untenRechts.x - obenLinks.x, untenRechts.y - obenLinks.y));
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object notifier = notification.getNotifier();
        int type = notification.getEventType();
        if (notifier instanceof MassstaeblicheDarstellung) {
            int featureID = notification.getFeatureID(DobjPackage.class);
            switch (type) {
                case 1: {
                    switch (featureID) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            this.updateProjektion();
                        }
                    }
                }
            }
        }
    }
}

