/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import de.bsvrz.buv.plugin.darstellung.commands.AddEbeneToDarstellungCommand;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.TreeContainerEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class DarstellungTreeEditPolicy
extends TreeContainerEditPolicy {
    public Command getCommand(Request req) {
        if ("move".equals(req.getType())) {
            return this.getMoveCommand((ChangeBoundsRequest)req);
        }
        return super.getCommand(req);
    }

    protected Command getMoveCommand(ChangeBoundsRequest req) {
        EditPart parent = this.getHost().getParent();
        if (parent != null) {
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move children");
            request.setEditParts(this.getHost());
            request.setLocation(req.getLocation());
            request.setMoveDelta(req.getMoveDelta());
            return parent.getCommand((Request)request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        Darstellung darstellung = (Darstellung)this.getHost().getModel();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (EditPart e : request.getEditParts()) {
            Object model = e.getModel();
            if (!(model instanceof Ebene)) continue;
            compoundCommand.add((Command)new AddEbeneToDarstellungCommand((Ebene)model, darstellung));
        }
        if (!compoundCommand.isEmpty()) {
            return compoundCommand;
        }
        return null;
    }

    protected Command getMoveChildrenCommand(ChangeBoundsRequest request) {
        return UnexecutableCommand.INSTANCE;
    }
}

