/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import de.bsvrz.buv.plugin.darstellung.commands.DeleteDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;

public class DoModelEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        DoModel doModel = (DoModel)this.getHost().getModel();
        return new DeleteDoModelCommand(doModel);
    }

    public Command getCommand(Request request) {
        if ("orphan".equals(request.getType()) && request instanceof ChangeBoundsRequest) {
            return this.createMoveCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    private Command createMoveCommand(ChangeBoundsRequest request) {
        EditPart editPart = (EditPart)request.getEditParts().get(0);
        DoModel model = (DoModel)editPart.getModel();
        Point location = this.getHotspotLocation(editPart, request.getLocation());
        return new MoveDoModelCommand(model, location);
    }

    private Point getHotspotLocation(EditPart child, Point boundsLocation) {
        HotspotConverter hotspotConverter = (HotspotConverter)child.getAdapter(HotspotConverter.class);
        if (hotspotConverter == null) {
            hotspotConverter = (HotspotConverter)Platform.getAdapterManager().getAdapter((Object)child, HotspotConverter.class);
        }
        Point location = hotspotConverter != null ? hotspotConverter.convertViewToModel(boundsLocation) : boundsLocation;
        return location;
    }
}

