/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import com.bitctrl.lib.eclipse.emf.gef.model.Sized;
import de.bsvrz.buv.plugin.darstellung.commands.CreateDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.ResizeDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.editpolicies.DoModelEditPolicy;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class EbeneXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child.getModel() instanceof DoModel && constraint instanceof Rectangle) {
            DoModel model = (DoModel)child.getModel();
            Rectangle bounds = (Rectangle)constraint;
            Point location = this.getHotspotLocation(child, bounds);
            CompoundCommand command = new CompoundCommand("Darstellungsobjekt Verschieben und Skalieren");
            command.add((Command)new MoveDoModelCommand(model, location));
            if (model instanceof Sized) {
                command.add((Command)new ResizeDoModelCommand(model, bounds.getSize()));
            }
            return command.unwrap();
        }
        return null;
    }

    private Point getHotspotLocation(EditPart child, Rectangle bounds) {
        HotspotConverter hotspotConverter = (HotspotConverter)child.getAdapter(HotspotConverter.class);
        if (hotspotConverter == null) {
            hotspotConverter = (HotspotConverter)Platform.getAdapterManager().getAdapter((Object)child, HotspotConverter.class);
        }
        Point location = hotspotConverter != null ? hotspotConverter.convertViewToModel(bounds.getLocation()) : bounds.getLocation();
        return location;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object childClass = request.getNewObjectType();
        if (childClass instanceof DoTyp) {
            Dimension size;
            Ebene ebene = (Ebene)this.getHost().getModel();
            DoModel model = (DoModel)request.getNewObject();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            CreateDoModelCommand cmd = new CreateDoModelCommand(model, ebene);
            cmd.setLocation(constraint.getLocation());
            if (model instanceof Sized && !(size = constraint.getSize()).isEmpty()) {
                cmd.setSize(size);
            }
            return cmd;
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof DoModelEditPart && ((DoModelEditPart)child).isEditor() && child.getModel() instanceof DoModel) {
            child.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new DoModelEditPolicy());
            if (child.getEditPolicy((Object)"PrimaryDrag Policy") != null) {
                return child.getEditPolicy((Object)"PrimaryDrag Policy");
            }
            if (child.getModel() instanceof Sized) {
                return new ResizableEditPolicy();
            }
            return new NonResizableEditPolicy();
        }
        return null;
    }
}

