/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.figures;

import com.bitctrl.lib.eclipse.draw2d.svg.SVGCache;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class EbeneFigure
extends LayeredPane {
    private Image hintergrund;
    private SVGCache svgCache;
    private double hintergrundSkalierung;
    private Point hintergrundLocation;

    public EbeneFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    public SVGCache getSvgCache() {
        return this.svgCache;
    }

    public void setSvgCache(SVGCache svgCache) {
        this.svgCache = svgCache;
        if (svgCache != null) {
            this.setHintergrund(null);
        }
    }

    public Image getHintergrund() {
        return this.hintergrund;
    }

    public void setHintergrund(Image hintergrund) {
        this.hintergrund = hintergrund;
        if (hintergrund != null) {
            this.setSvgCache(null);
        }
    }

    public double getHintergrundSkalierung() {
        return this.hintergrundSkalierung;
    }

    public void setHintergrundSkalierung(double hintergrundSkalierung) {
        this.hintergrundSkalierung = hintergrundSkalierung;
        this.repaint();
    }

    public Point getHintergrundLocation() {
        return this.hintergrundLocation;
    }

    public void setHintergrundLocation(Point hintergrundLocation) {
        this.hintergrundLocation = hintergrundLocation;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.getBorder() instanceof AbstractBackground) {
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
        }
        if (this.hintergrund != null) {
            Point location = this.getHintergrundLocation() != null ? this.getHintergrundLocation() : new Point();
            if (graphics instanceof ScaledGraphics) {
                graphics.scale(this.hintergrundSkalierung);
            }
            graphics.drawImage(this.hintergrund, location);
        } else if (this.svgCache != null && this.svgCache.checkContentAvailable()) {
            Image svgHintergrund = JFaceResources.getImageRegistry().get(this.svgCache.getURI());
            if (svgHintergrund == null) {
                svgHintergrund = this.svgCache.createImage(this.getClientArea(), graphics);
                JFaceResources.getImageRegistry().put(this.svgCache.getURI(), svgHintergrund);
            }
            graphics.drawImage(svgHintergrund, this.getClientArea().getLocation());
        }
    }

    public Rectangle getBounds() {
        if (this.getParent() != null) {
            return this.getParent().getBounds();
        }
        return super.getBounds();
    }
}

