/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import com.bitctrl.lib.eclipse.emf.dav.mock.MockDavObject;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.objfilter.Filter;
import de.bsvrz.sys.funclib.objfilter.interpreter.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class AutoEbeneImpl
extends EbeneImpl
implements AutoEbene {
    protected EList<SystemObjectType> systemObjectTypes;
    protected EList<ConfigurationArea> configurationAreas;
    protected EList<SystemObject> systemObjects;
    protected EList<MutableSet> mutableSets;
    protected EList<DoTyp> doTypen;
    protected EList<DoModel> autoDoObjekte;
    protected EList<SystemObject> systemObjectsExcludes;
    protected EList<String> objektFilter;

    protected AutoEbeneImpl() {
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                int featureID = notification.getFeatureID(Ebene.class);
                if (notifier instanceof AutoEbene) {
                    switch (type) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            switch (featureID) {
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    AutoEbeneImpl.this.autoDoObjekte = null;
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    protected EClass eStaticClass() {
        return DarstellungPackage.Literals.AUTO_EBENE;
    }

    @Override
    public EList<SystemObjectType> getSystemObjectTypes() {
        if (this.systemObjectTypes == null) {
            this.systemObjectTypes = new EDataTypeUniqueEList(SystemObjectType.class, (InternalEObject)this, 10);
        }
        return this.systemObjectTypes;
    }

    @Override
    public EList<ConfigurationArea> getConfigurationAreas() {
        if (this.configurationAreas == null) {
            this.configurationAreas = new EDataTypeUniqueEList(ConfigurationArea.class, (InternalEObject)this, 11);
        }
        return this.configurationAreas;
    }

    @Override
    public EList<SystemObject> getSystemObjects() {
        if (this.systemObjects == null) {
            this.systemObjects = new EDataTypeUniqueEList(SystemObject.class, (InternalEObject)this, 12);
        }
        return this.systemObjects;
    }

    @Override
    public EList<MutableSet> getMutableSets() {
        if (this.mutableSets == null) {
            this.mutableSets = new EDataTypeUniqueEList(MutableSet.class, (InternalEObject)this, 13);
        }
        return this.mutableSets;
    }

    @Override
    public EList<DoTyp> getDoTypen() {
        if (this.doTypen == null) {
            this.doTypen = new EObjectResolvingEList(DoTyp.class, (InternalEObject)this, 14);
        }
        return this.doTypen;
    }

    @Override
    public EList<DoModel> getAutoDoObjekte() {
        long t = System.currentTimeMillis();
        this.autoDoObjekte = new BasicEList();
        ArrayList<DoTyp> doTypenCopy = new ArrayList<DoTyp>((Collection<DoTyp>)this.getDoTypen());
        if (doTypenCopy.isEmpty()) {
            return ECollections.emptyEList();
        }
        ArrayList<SystemObjectType> systemObjectTypesCopy = new ArrayList<SystemObjectType>((Collection<SystemObjectType>)this.getSystemObjectTypes());
        List<Object> configurationAreasCopy = new ArrayList<ConfigurationArea>((Collection<ConfigurationArea>)this.getConfigurationAreas());
        ArrayList<MutableSet> mutableSetsCopy = new ArrayList<MutableSet>((Collection<MutableSet>)this.getMutableSets());
        ArrayList<SystemObject> systemObjectsCopy = new ArrayList<SystemObject>((Collection<SystemObject>)this.getSystemObjects());
        HashSet<SystemObject> systemObjectsExcludesCopy = new HashSet<SystemObject>((Collection<SystemObject>)this.getSystemObjectsExcludes());
        HashSet<SystemObject> objects = new HashSet<SystemObject>();
        List<Object> configuratedObjectTypes = new ArrayList();
        ArrayList<SystemObjectType> dynamicObjectTypes = new ArrayList<SystemObjectType>();
        for (SystemObjectType sot : systemObjectTypesCopy) {
            if (sot.isConfigurating()) {
                configuratedObjectTypes.add(sot);
                continue;
            }
            dynamicObjectTypes.add(sot);
        }
        configuratedObjectTypes = configuratedObjectTypes.stream().filter(o -> !(o instanceof MockDavObject)).collect(Collectors.toList());
        configurationAreasCopy = configurationAreasCopy.stream().filter(o -> !(o instanceof MockDavObject)).collect(Collectors.toList());
        if (!(configuratedObjectTypes.isEmpty() && configurationAreasCopy.isEmpty() || !RahmenwerkService.getService().getObjektFactory().isVerbunden())) {
            DataModel model = RahmenwerkService.getService().getObjektFactory().getDav().getDataModel();
            objects.addAll(model.getObjects(configurationAreasCopy.isEmpty() ? null : configurationAreasCopy, configuratedObjectTypes.isEmpty() ? null : configuratedObjectTypes, ObjectTimeSpecification.valid()));
        }
        for (SystemObject so : systemObjectsCopy) {
            if (objects.contains(so)) continue;
            objects.add(so);
        }
        for (MutableSet set : mutableSetsCopy) {
            for (SystemObject so : set.getElements()) {
                if (!dynamicObjectTypes.isEmpty() && !dynamicObjectTypes.contains(so.getType())) continue;
                objects.add(so);
            }
        }
        List korrekteFilter = this.getObjektFilter().stream().map(s -> Interpreter.createFilterFromString((String)s)).filter(f -> f.getParseErrors().isEmpty()).collect(Collectors.toList());
        for (SystemObject so : objects) {
            Optional<Filter> any;
            List filterMitPassendemTyp;
            if (systemObjectsExcludesCopy.contains(so) || !(filterMitPassendemTyp = korrekteFilter.stream().filter(f -> so.isOfType(f.getTypPid())).collect(Collectors.toList())).isEmpty() && !(any = filterMitPassendemTyp.stream().filter(f -> f.auswerten(so).getPassiert().contains(so)).findAny()).isPresent()) continue;
            for (DoTyp doTyp : doTypenCopy) {
                if (doTyp.getSystemObjectType() == null || !so.isOfType(doTyp.getSystemObjectType())) continue;
                DoModel doModel = doTyp.createModel();
                doModel.setSystemObject(so);
                this.autoDoObjekte.add((Object)doModel);
            }
        }
        t = System.currentTimeMillis() - t;
        Debug.getLogger().fine(this.getClass().getSimpleName() + "#getAutoDoObjekte(Ebene=" + this.getName() + "): " + t / 1000L + " Sekunden");
        return this.autoDoObjekte;
    }

    @Override
    public EList<SystemObject> getSystemObjectsExcludes() {
        if (this.systemObjectsExcludes == null) {
            this.systemObjectsExcludes = new EDataTypeUniqueEList(SystemObject.class, (InternalEObject)this, 16);
        }
        return this.systemObjectsExcludes;
    }

    @Override
    public EList<String> getObjektFilter() {
        if (this.objektFilter == null) {
            this.objektFilter = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 17);
        }
        return this.objektFilter;
    }

    @Override
    public boolean isAutomatischVerwaltbar(DoModel modellObjekt) {
        return this.getDoTypen().contains((Object)modellObjekt.getDoTyp());
    }

    @Override
    public boolean isAutomatischVerwaltet(DoModel modellObjekt) {
        return !this.getSystemObjectsExcludes().contains((Object)modellObjekt.getSystemObject()) && !this.getDoObjekte().contains((Object)modellObjekt) && modellObjekt.getLocation() == null;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getSystemObjectTypes();
            }
            case 11: {
                return this.getConfigurationAreas();
            }
            case 12: {
                return this.getSystemObjects();
            }
            case 13: {
                return this.getMutableSets();
            }
            case 14: {
                return this.getDoTypen();
            }
            case 15: {
                return this.getAutoDoObjekte();
            }
            case 16: {
                return this.getSystemObjectsExcludes();
            }
            case 17: {
                return this.getObjektFilter();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.getSystemObjectTypes().clear();
                this.getSystemObjectTypes().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getConfigurationAreas().clear();
                this.getConfigurationAreas().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getSystemObjects().clear();
                this.getSystemObjects().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getMutableSets().clear();
                this.getMutableSets().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getDoTypen().clear();
                this.getDoTypen().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.getSystemObjectsExcludes().clear();
                this.getSystemObjectsExcludes().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getObjektFilter().clear();
                this.getObjektFilter().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.getSystemObjectTypes().clear();
                return;
            }
            case 11: {
                this.getConfigurationAreas().clear();
                return;
            }
            case 12: {
                this.getSystemObjects().clear();
                return;
            }
            case 13: {
                this.getMutableSets().clear();
                return;
            }
            case 14: {
                this.getDoTypen().clear();
                return;
            }
            case 16: {
                this.getSystemObjectsExcludes().clear();
                return;
            }
            case 17: {
                this.getObjektFilter().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.systemObjectTypes != null && !this.systemObjectTypes.isEmpty();
            }
            case 11: {
                return this.configurationAreas != null && !this.configurationAreas.isEmpty();
            }
            case 12: {
                return this.systemObjects != null && !this.systemObjects.isEmpty();
            }
            case 13: {
                return this.mutableSets != null && !this.mutableSets.isEmpty();
            }
            case 14: {
                return this.doTypen != null && !this.doTypen.isEmpty();
            }
            case 15: {
                return this.autoDoObjekte != null && !this.autoDoObjekte.isEmpty();
            }
            case 16: {
                return this.systemObjectsExcludes != null && !this.systemObjectsExcludes.isEmpty();
            }
            case 17: {
                return this.objektFilter != null && !this.objektFilter.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (systemObjectTypes: ");
        result.append(this.systemObjectTypes);
        result.append(", configurationAreas: ");
        result.append(this.configurationAreas);
        result.append(", systemObjects: ");
        result.append(this.systemObjects);
        result.append(", mutableSets: ");
        result.append(this.mutableSets);
        result.append(", systemObjectsExcludes: ");
        result.append(this.systemObjectsExcludes);
        result.append(", objektFilter: ");
        result.append(this.objektFilter);
        result.append(')');
        return result.toString();
    }
}

