/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.search;

import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public class ObjekteSucheDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "ObjekteSucheDialogSettings";
    private final GraphicalViewer graphicalViewer;
    private final SuchenLabelProvider listLabelProvider = new SuchenLabelProvider();

    public ObjekteSucheDialog(Shell shell, GraphicalViewer graphicalViewer) {
        super(shell);
        this.graphicalViewer = graphicalViewer;
        this.setListLabelProvider((ILabelProvider)this.listLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new SucheDetailsLabelProvicer());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DObjPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = DObjPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ItemsFilterExtension();
    }

    protected Comparator<?> getItemsComparator() {
        return Comparator.comparing(Object::toString);
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        Map editPartRegistry = this.graphicalViewer.getEditPartRegistry();
        progressMonitor.beginTask("Suche ...", editPartRegistry.size());
        editPartRegistry.values().stream().filter(DoModelEditPart.class::isInstance).map(DoModelEditPart.class::cast).filter(m -> ((DoModel)m.getModel()).getDoTyp().isSuchbar()).forEach(c -> {
            contentProvider.add((Object)c, itemsFilter);
            progressMonitor.worked(1);
        });
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return this.listLabelProvider.getText(item);
    }

    private final class ItemsFilterExtension
    extends FilteredItemsSelectionDialog.ItemsFilter {
        ItemsFilterExtension() {
            this(new SearchPattern());
        }

        ItemsFilterExtension(SearchPattern pattern) {
            Control control;
            super((FilteredItemsSelectionDialog)ObjekteSucheDialog.this, pattern);
            Object stringPattern = "";
            if (pattern != null && (control = ObjekteSucheDialog.this.getPatternControl()) instanceof Text) {
                Text text = (Text)control;
                stringPattern = "*" + text.getText();
            }
            this.patternMatcher.setPattern((String)stringPattern);
        }

        public boolean matchItem(Object item) {
            return this.matches(ObjekteSucheDialog.this.listLabelProvider.getText(item));
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public String getPattern() {
            String pattern = super.getPattern();
            if (pattern.isEmpty()) {
                return "?";
            }
            return pattern;
        }
    }

    private final class SucheDetailsLabelProvicer
    extends SuchenLabelProvider {
        private SucheDetailsLabelProvicer() {
        }

        @Override
        public String getText(Object element) {
            StringBuilder result = new StringBuilder().append(super.getText(element));
            if (element instanceof DoModelEditPart) {
                DoModelEditPart editpart = (DoModelEditPart)((Object)element);
                result.append(" - ").append(((DoModel)editpart.getModel()).getDoTyp().getName());
            }
            return result.toString();
        }
    }

    private class SuchenLabelProvider
    extends LabelProvider {
        private SuchenLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DoModelEditPart) {
                DoModelEditPart editpart = (DoModelEditPart)((Object)element);
                String result = !editpart.isSelectable() ? "[unsichtbar] " : "";
                return result + editpart.getSuchText();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ILegendeBaustein iLegendeBaustein = (ILegendeBaustein)Adapters.adapt((Object)element, ILegendeBaustein.class);
            if (iLegendeBaustein instanceof ILegendeBaustein) {
                ILegendeBaustein legende = iLegendeBaustein;
                return legende.getIcon();
            }
            return super.getImage(element);
        }
    }
}

