/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.util;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DarstellungAdapter
extends EContentAdapter {
    private boolean internalUpdate = false;

    public boolean isAdapterForType(Object type) {
        return type == Darstellung.class;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.internalUpdate) {
            return;
        }
        if (notification.getNotifier() instanceof Darstellung) {
            this.handleDarstellung(notification);
        } else if (notification.getNotifier() instanceof Ebene) {
            this.handleEbene(notification);
        } else if (notification.getNotifier() instanceof DarstellungsSpalte) {
            this.handleDarstellungsSpalte(notification);
        } else if (notification.getNotifier() instanceof DoKompositum) {
            this.handleDoKompositum(notification);
        }
    }

    private void handleDarstellung(Notification notification) {
        if (notification.getFeature() == DarstellungPackage.eINSTANCE.getDarstellung_DoTypen()) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.sortDoTypenInDarstellung(notification);
                }
            }
        }
    }

    private void sortDoTypenInDarstellung(Notification notification) {
        Darstellung darstellung = (Darstellung)notification.getNotifier();
    }

    private void handleDarstellungsSpalte(Notification notification) {
        if (notification.getFeature() == DarstellungPackage.eINSTANCE.getDarstellungsSpalte_Width()) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    this.handleDarstellungsSpalteWidthChanged(notification);
                }
            }
        }
    }

    private void handleDarstellungsSpalteWidthChanged(Notification notification) {
        DarstellungsSpalte spalte = (DarstellungsSpalte)notification.getNotifier();
        StilisierteDarstellung darstellung = (StilisierteDarstellung)DarstellungAdapter.getDarstellung((EObject)spalte);
        int width = 0;
        if (darstellung != null) {
            for (DarstellungsSpalte e : darstellung.getSpalten()) {
                width += e.getWidth();
            }
            Dimension size = darstellung.getSize();
            darstellung.setSize(new Dimension(width, size.height));
        }
    }

    private void handleDoKompositum(Notification notification) {
        if (notification.getFeature() == DobjPackage.eINSTANCE.getDoKompositum_Komponenten()) {
            switch (notification.getEventType()) {
                case 3: 
                case 5: {
                    this.handleAddDoModelToDoKompositum(notification);
                    break;
                }
                case 4: 
                case 6: {
                    this.handleRemoveDoModelFromDoKompositum(notification);
                }
            }
        }
    }

    private void handleAddDoModelToDoKompositum(Notification notification) {
        DoKompositum kompositum = (DoKompositum)notification.getNotifier();
        Darstellung darstellung = DarstellungAdapter.getDarstellung(kompositum);
        Object value = notification.getNewValue();
        if (value instanceof List) {
            List list = (List)value;
            for (DoModel model : list) {
                this.addNonExistDoTypenToDarstellung(model, darstellung);
            }
        } else {
            this.addNonExistDoTypenToDarstellung((DoModel)value, darstellung);
        }
    }

    public static Darstellung getDarstellung(EObject object) {
        EObject container = object.eContainer();
        if (container instanceof Darstellung) {
            return (Darstellung)container;
        }
        if (container != null) {
            return DarstellungAdapter.getDarstellung(container);
        }
        return null;
    }

    private void handleRemoveDoModelFromDoKompositum(Notification notification) {
        DoKompositum kompositum = (DoKompositum)notification.getNotifier();
        Darstellung darstellung = DarstellungAdapter.getDarstellung(kompositum);
        Object value = notification.getOldValue();
        if (value instanceof List) {
            List list = (List)value;
            for (DoModel model : list) {
                this.removeNonUsedDoTypenFromDarstellung(model, darstellung);
            }
        } else {
            this.removeNonUsedDoTypenFromDarstellung((DoModel)value, darstellung);
        }
    }

    private void handleEbene(Notification notification) {
        if (notification.getFeature() == DarstellungPackage.eINSTANCE.getEbene_DoObjekte()) {
            switch (notification.getEventType()) {
                case 3: 
                case 5: {
                    this.handleAddDoModelToEbene(notification);
                    break;
                }
                case 4: 
                case 6: {
                    this.handleRemoveDoModelFromEbene(notification);
                }
            }
        } else if (notification.getFeature() == DarstellungPackage.eINSTANCE.getAutoEbene_DoTypen()) {
            switch (notification.getEventType()) {
                case 3: 
                case 5: {
                    this.handleAddDoTypToAutoEbene(notification);
                    break;
                }
                case 4: 
                case 6: {
                    this.handleRemoveDoTypFromAutoEbene(notification);
                }
            }
        }
    }

    private void handleAddDoTypToAutoEbene(Notification notification) {
        Ebene ebene = (Ebene)notification.getNotifier();
        Object value = notification.getNewValue();
        if (value instanceof List) {
            List list = (List)value;
            for (DoTyp doTyp : list) {
                Optional<DoTyp> optional = ebene.getEbeneDoTypen().stream().filter(t -> Objects.equals(t.getId(), doTyp.getId())).findFirst();
                if (optional.isPresent()) continue;
                ebene.getEbeneDoTypen().add((Object)((DoTyp)EcoreUtil.copy((EObject)doTyp)));
            }
        } else {
            Optional<DoTyp> optional = ebene.getEbeneDoTypen().stream().filter(t -> Objects.equals(t.getId(), ((DoTyp)value).getId())).findFirst();
            if (!optional.isPresent()) {
                ebene.getEbeneDoTypen().add((Object)((DoTyp)EcoreUtil.copy((EObject)((DoTyp)value))));
            }
        }
    }

    private void handleAddDoModelToEbene(Notification notification) {
        Ebene ebene = (Ebene)notification.getNotifier();
        Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)ebene);
        Object value = notification.getNewValue();
        if (value instanceof List) {
            List list = (List)value;
            for (DoModel model : list) {
                this.addNonExistDoTypenToDarstellung(model, darstellung);
                this.addNonExistDoTypenToEbene(model, ebene);
            }
        } else {
            this.addNonExistDoTypenToDarstellung((DoModel)value, darstellung);
            this.addNonExistDoTypenToEbene((DoModel)value, ebene);
        }
    }

    private void addNonExistDoTypenToEbene(DoModel model, Ebene ebene) {
        List<DoTyp> doTypen = DarstellungAdapter.getNonExistDoTypen(ebene, model);
        ebene.getEbeneDoTypen().addAll((Collection)doTypen.stream().map(e -> (DoTyp)EcoreUtil.copy((EObject)e)).collect(Collectors.toList()));
    }

    private void addNonExistDoTypenToDarstellung(DoModel model, Darstellung darstellung) {
        List<DoTyp> doTypen = DarstellungAdapter.getNonExistDoTypenAndUpdateModelWithExistDoTypen(darstellung, model);
        darstellung.getDoTypen().addAll(doTypen);
    }

    private void handleRemoveDoTypFromAutoEbene(Notification notification) {
        Ebene ebene = (Ebene)notification.getNotifier();
        Object value = notification.getOldValue();
        if (value instanceof List) {
            List list = (List)value;
            ebene.getEbeneDoTypen().removeAll((Collection)list);
        } else {
            ebene.getEbeneDoTypen().remove(value);
        }
    }

    private void handleRemoveDoModelFromEbene(Notification notification) {
        Ebene ebene = (Ebene)notification.getNotifier();
        Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)ebene);
        Object value = notification.getOldValue();
        if (value instanceof List) {
            List list = (List)value;
            for (DoModel model : list) {
                this.removeNonUsedDoTypenFromDarstellung(model, darstellung);
                this.removeNonUsedDoTypenFromEbene(model, ebene);
            }
        } else {
            this.removeNonUsedDoTypenFromDarstellung((DoModel)value, darstellung);
            this.removeNonUsedDoTypenFromEbene((DoModel)value, ebene);
        }
    }

    private void removeNonUsedDoTypenFromEbene(DoModel model, Ebene ebene) {
        List<DoTyp> doTypen = DarstellungAdapter.getNonUsedDoTypen(ebene, model);
        for (DoTyp dot : doTypen) {
            List zuLoeschendeTypen = ebene.getEbeneDoTypen().stream().filter(e -> Objects.equals(e.getId(), dot.getId())).collect(Collectors.toList());
            ebene.getEbeneDoTypen().removeAll(zuLoeschendeTypen);
        }
    }

    private void removeNonUsedDoTypenFromDarstellung(DoModel model, Darstellung darstellung) {
        List<DoTyp> doTypen = DarstellungAdapter.getNonUsedDoTypen(darstellung, model);
        darstellung.getDoTypen().removeAll(doTypen);
    }

    private static List<DoTyp> getNonUsedDoTypen(Darstellung d, DoModel model) {
        ArrayList<DoTyp> result = new ArrayList<DoTyp>();
        Set<DoTyp> usedDoTypen = DarstellungAdapter.getDoTypen(model);
        for (DoTyp doTyp : usedDoTypen) {
            if (DarstellungAdapter.isUsedDoTypInDarstellung(doTyp, d, Collections.singleton(model))) continue;
            result.add(doTyp);
        }
        return result;
    }

    private static List<DoTyp> getNonUsedDoTypen(Ebene e, DoModel model) {
        ArrayList<DoTyp> result = new ArrayList<DoTyp>();
        Set<DoTyp> usedDoTypen = DarstellungAdapter.getDoTypen(model);
        for (DoTyp doTyp : usedDoTypen) {
            if (DarstellungAdapter.isUsedDoTypInEbene(doTyp, e, Collections.singleton(model))) continue;
            result.add(doTyp);
        }
        return result;
    }

    private static Set<DoTyp> getDoTypen(DoModel model) {
        LinkedHashSet<DoTyp> doTypen = new LinkedHashSet<DoTyp>();
        doTypen.add(model.getDoTyp());
        if (model instanceof DoKompositum) {
            DoKompositum kompositum = (DoKompositum)((Object)model);
            for (DoModel komponente : kompositum.getKomponenten()) {
                doTypen.addAll(DarstellungAdapter.getDoTypen(komponente));
            }
        }
        return doTypen;
    }

    private static boolean isUsedDoTypInDarstellung(DoTyp doTyp, Darstellung darstellung, Collection<DoModel> excludes) {
        for (Ebene ebene : darstellung.getEbenen()) {
            if (!DarstellungAdapter.isUsedDoTypInEbene(doTyp, ebene, excludes)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsedDoTypInEbene(DoTyp doTyp, Ebene ebene, Collection<DoModel> excludes) {
        if (ebene instanceof AutoEbene) {
            AutoEbene autoEbene = (AutoEbene)ebene;
            for (DoTyp dot : autoEbene.getDoTypen()) {
                if (dot != doTyp) continue;
                return true;
            }
        }
        for (DoModel model : ebene.getDoObjekte()) {
            DoKompositum kompositum;
            if (excludes.contains(model)) continue;
            if (model.getDoTyp() == doTyp) {
                return true;
            }
            if (!(model instanceof DoKompositum) || !DarstellungAdapter.isUsedDoTypInKompositum(doTyp, kompositum = (DoKompositum)((Object)model), excludes)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsedDoTypInKompositum(DoTyp doTyp, DoKompositum<DoModel> kompositum, Collection<DoModel> excludes) {
        for (DoModel komponente : kompositum.getKomponenten()) {
            DoKompositum k;
            DoModel model;
            if (!(komponente instanceof DoModel) || excludes.contains(model = komponente)) continue;
            if (model.getDoTyp() == doTyp) {
                return true;
            }
            if (!(model instanceof DoKompositum) || !DarstellungAdapter.isUsedDoTypInKompositum(doTyp, k = (DoKompositum)((Object)model), excludes)) continue;
            return true;
        }
        return false;
    }

    private static List<DoTyp> getNonExistDoTypenAndUpdateModelWithExistDoTypen(Darstellung d, DoModel model) {
        return DarstellungAdapter.getDoTypAndUpdateModelIfNecessary(d, model, new ArrayList<DoTyp>());
    }

    private static List<DoTyp> getNonExistDoTypen(Ebene e, DoModel model) {
        return DarstellungAdapter.getDoTyp(e, model, new ArrayList<DoTyp>()).stream().filter(t -> !e.getEbeneDoTypen().contains(t)).collect(Collectors.toList());
    }

    private static List<DoTyp> getDoTyp(Ebene e, DoModel model, List<DoTyp> doTypen) {
        DoTyp dot = DarstellungAdapter.getDoTyp(e, model.getDoTyp());
        if (dot == null) {
            dot = DarstellungAdapter.getDoTyp(doTypen, model.getDoTyp());
        }
        if (dot != null) {
            doTypen.add(dot);
        }
        if (model instanceof DoKompositum) {
            EList komponenten = ((DoKompositum)((Object)model)).getKomponenten();
            for (DoModel komponente : komponenten) {
                DarstellungAdapter.getDoTyp(e, komponente, doTypen);
            }
        }
        return doTypen;
    }

    private static List<DoTyp> getDoTypAndUpdateModelIfNecessary(Darstellung d, DoModel model, List<DoTyp> doTypen) {
        DoTyp dot = DarstellungAdapter.getDoTyp(d.getDoTypen(), model.getDoTyp());
        if (dot == null) {
            dot = DarstellungAdapter.getDoTyp(doTypen, model.getDoTyp());
        }
        if (dot != null) {
            model.setDoTyp(dot);
        } else {
            doTypen.add(model.getDoTyp());
        }
        if (model instanceof DoKompositum) {
            EList komponenten = ((DoKompositum)((Object)model)).getKomponenten();
            for (DoModel komponente : komponenten) {
                DarstellungAdapter.getDoTypAndUpdateModelIfNecessary(d, komponente, doTypen);
            }
        }
        return doTypen;
    }

    private static DoTyp getDoTyp(Collection<DoTyp> doTypen, DoTyp doTyp) {
        block3: {
            block2: {
                if (!(doTyp instanceof ConfiguratedDoTyp)) break block2;
                ConfiguratedDoTyp modelDot = (ConfiguratedDoTyp)doTyp;
                for (DoTyp dot : doTypen) {
                    if (!(dot instanceof ConfiguratedDoTyp)) continue;
                    ConfiguratedDoTyp darstellungDot = (ConfiguratedDoTyp)dot;
                    if (!modelDot.getId().equals(darstellungDot.getId())) continue;
                    return darstellungDot;
                }
                break block3;
            }
            if (!(doTyp instanceof EditorDoTypReferenz)) break block3;
            EditorDoTypReferenz modelDot = (EditorDoTypReferenz)doTyp;
            for (DoTyp dot : doTypen) {
                if (!(dot instanceof EditorDoTypReferenz)) continue;
                EditorDoTypReferenz darstellungDot = (EditorDoTypReferenz)dot;
                if (!modelDot.getSystemObjekt().equals(darstellungDot.getSystemObjekt())) continue;
                return darstellungDot;
            }
        }
        return null;
    }

    private static DoTyp getDoTyp(Ebene ebene, DoTyp doTyp) {
        DoTyp result = DarstellungAdapter.getDoTyp(ebene.getEbeneDoTypen(), doTyp);
        if (result == null) {
            if (ebene.eContainer() instanceof Ebene) {
                result = DarstellungAdapter.getDoTyp((Ebene)ebene.eContainer(), doTyp);
            } else if (ebene.eContainer() instanceof Darstellung) {
                result = DarstellungAdapter.getDoTyp(((Darstellung)ebene.eContainer()).getDoTypen(), doTyp);
            }
        }
        return result;
    }
}

