/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.util;

import com.bitctrl.lib.eclipse.emf.dav.mock.MockDavObject;
import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.EMFIDModellEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.EObjectStatusImpl;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.objfilter.interpreter.Interpreter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class DarstellungValidator {
    private DarstellungValidator() {
    }

    private static IStatus createNewProblemMarker(DoModel o) {
        EObjectStatusImpl result = new EObjectStatusImpl(2, "de.bsvrz.buv.plugin.dobj", 0, "Das SystemObject mit der PID " + o.getSystemObject().getPid() + " existiert nicht.", o);
        return result;
    }

    private static IStatus createNewProblemMarker(DoTyp o) {
        EObjectStatusImpl result = new EObjectStatusImpl(2, "de.bsvrz.buv.plugin.dobj", 0, "Der SystemObjectTyp mit der PID " + o.getSystemObjectType().getPid() + " existiert nicht.", (EObject)o);
        return result;
    }

    public static IStatus validiereSystemObjects(Named model) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        model.eAllContents().forEachRemaining(list::add);
        List<IStatus> result = DarstellungValidator.findeProblematischeDarstellungsObjekte(list);
        result.addAll(DarstellungValidator.findeProblematischeDarstellungsObjektTypen(list));
        result.addAll(DarstellungValidator.findeProblematischeEbenen(list));
        result.addAll(DarstellungValidator.findeObjektFilterProbleme(list));
        if (result.isEmpty()) {
            return Status.OK_STATUS;
        }
        return new MultiStatus("de.bsvrz.buv.plugin.dobj", 2, result.toArray(new IStatus[0]), "Die Darstellung " + model.getName() + " enth\u00e4lt " + result.size() + " Probleme bzw. Warnungen.", null);
    }

    public static IStatus validiereInstallierteDarstellungsobjekte(Named model) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)model);
        if (diagnostic.getSeverity() == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.dobj", diagnostic.getCode(), diagnostic.getMessage(), diagnostic.getException());
        for (Object name : diagnostic.getChildren()) {
            int severity;
            Diagnostic childDiagnostic = (Diagnostic)name;
            switch (childDiagnostic.getSeverity()) {
                case 2: {
                    int n = 2;
                    break;
                }
                case 4: {
                    int n = 4;
                    break;
                }
                default: {
                    int n = severity = 1;
                }
            }
            if (!childDiagnostic.getData().isEmpty()) {
                MultiStatus childStatus = new MultiStatus("de.bsvrz.buv.plugin.dobj", childDiagnostic.getCode(), childDiagnostic.getMessage(), childDiagnostic.getException());
                for (Object obj : childDiagnostic.getData()) {
                    if (!(obj instanceof DoTyp)) continue;
                    DoTyp typ = (DoTyp)obj;
                    childStatus.add((IStatus)new Status(severity, "de.bsvrz.buv.plugin.dobj", "Unbekannter Darstellungsobjekttyp mit Namen \"" + typ.getName() + "\" und ID " + typ.getId() + " eventuell kann diese Darstellungsobjekt noch nach installiert werden.", null));
                }
                status.add((IStatus)childStatus);
                continue;
            }
            status.add((IStatus)new Status(severity, "de.bsvrz.buv.plugin.dobj", childDiagnostic.getMessage(), childDiagnostic.getException()));
        }
        return status;
    }

    private static List<IStatus> findeObjektFilterProbleme(List<EObject> list) {
        return list.parallelStream().filter(o -> o instanceof AutoEbene).map(o -> (AutoEbene)o).map(e -> DarstellungValidator.createObjektFilterProblemMarker(e)).filter(s -> !Status.OK_STATUS.equals(s)).collect(Collectors.toList());
    }

    private static IStatus createObjektFilterProblemMarker(AutoEbene e) {
        List fehler = e.getObjektFilter().parallelStream().map(s -> Interpreter.createFilterFromString((String)s)).flatMap(f -> f.verifizieren().stream()).collect(Collectors.toList());
        if (!fehler.isEmpty()) {
            String name = e.getName();
            if (name.isEmpty()) {
                name = "[ohne Name]";
            }
            MultiStatus childStatus = new MultiStatus("de.bsvrz.buv.plugin.dobj", 2, "Die Ebene " + name + " enth\u00e4lt Objektfilter mit folgenden Problemen.", null);
            fehler.stream().map(f -> new Status(2, "de.bsvrz.buv.plugin.dobj", f.getFehlerText())).forEach(s -> childStatus.add((IStatus)s));
            return childStatus;
        }
        return Status.OK_STATUS;
    }

    private static List<IStatus> findeProblematischeEbenen(List<EObject> list) {
        return list.stream().filter(o -> o instanceof AutoEbene).map(o -> (AutoEbene)o).filter(e -> DarstellungValidator.hatEbeneFehler(e)).map(e -> DarstellungValidator.createNewEbneneProblemMarker(e)).collect(Collectors.toList());
    }

    private static IStatus createNewEbneneProblemMarker(AutoEbene e) {
        List mocks = e.getSystemObjects().stream().filter(o -> o instanceof MockDavObject).collect(Collectors.toList());
        mocks.addAll(e.getSystemObjectsExcludes().stream().filter(o -> o instanceof MockDavObject).collect(Collectors.toList()));
        mocks.addAll(e.getSystemObjectTypes().stream().filter(o -> o instanceof MockDavObject).collect(Collectors.toList()));
        mocks.addAll(e.getConfigurationAreas().stream().filter(o -> o instanceof MockDavObject).collect(Collectors.toList()));
        return new EObjectStatusImpl(2, "de.bsvrz.buv.plugin.dobj", 0, "Die Autoebene " + e.getName() + " enth\u00e4lt " + mocks.size() + " fehlerhafte Referenzen (" + mocks.stream().map(SystemObject::getPid).collect(Collectors.joining(",")) + ")", (EObject)e);
    }

    private static boolean hatEbeneFehler(AutoEbene e) {
        boolean result = e.getSystemObjects().stream().anyMatch(o -> o instanceof MockDavObject);
        result |= e.getSystemObjectsExcludes().stream().anyMatch(o -> o instanceof MockDavObject);
        result |= e.getSystemObjectTypes().stream().anyMatch(o -> o instanceof MockDavObject);
        return result |= e.getConfigurationAreas().stream().anyMatch(o -> o instanceof MockDavObject);
    }

    private static List<IStatus> findeProblematischeDarstellungsObjektTypen(List<EObject> list) {
        return list.stream().filter(o -> o instanceof DoTyp).map(o -> (DoTyp)o).filter(o -> o.getSystemObjectType() instanceof MockDavObject).map(o -> DarstellungValidator.createNewProblemMarker(o)).collect(Collectors.toList());
    }

    private static List<IStatus> findeProblematischeDarstellungsObjekte(List<EObject> list) {
        return list.stream().filter(o -> o instanceof DoModel).map(o -> (DoModel)o).filter(o -> o.getSystemObject() instanceof MockDavObject).map(o -> DarstellungValidator.createNewProblemMarker(o)).collect(Collectors.toList());
    }

    public static List<IStatus> validiere(Named model) {
        IStatus validiereParserFehler = DarstellungValidator.validiereParserFehler(model);
        IStatus validiereInstallierteDarstellungsobjekte = DarstellungValidator.validiereInstallierteDarstellungsobjekte(model);
        IStatus validiereSystemObjects = DarstellungValidator.validiereSystemObjects(model);
        if (Status.OK_STATUS.equals(validiereParserFehler) && Status.OK_STATUS.equals(validiereSystemObjects) && Status.OK_STATUS.equals(validiereInstallierteDarstellungsobjekte)) {
            return Arrays.asList(Status.OK_STATUS);
        }
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        if (!Status.OK_STATUS.equals(validiereParserFehler)) {
            result.add(validiereParserFehler);
        }
        if (!Status.OK_STATUS.equals(validiereInstallierteDarstellungsobjekte)) {
            result.add(validiereInstallierteDarstellungsobjekte);
        }
        if (!Status.OK_STATUS.equals(validiereSystemObjects)) {
            result.add(validiereSystemObjects);
        }
        return result;
    }

    private static IStatus validiereParserFehler(Named model) {
        EMFIDModellEinstellungen einstellungen = null;
        if (model instanceof Ansicht) {
            einstellungen = AnsichtenEinstellungen.INSTANCE;
        } else if (model instanceof Darstellung) {
            einstellungen = DarstellungenEinstellungen.INSTANCE;
        } else {
            return Status.OK_STATUS;
        }
        List<Resource.Diagnostic> modellEinstellungDiagnostic = einstellungen.getModellEinstellungDiagnostic(EcoreUtil.getID((EObject)model));
        List list = modellEinstellungDiagnostic.stream().map(w -> new Status(4, "de.bsvrz.buv.plugin.dobj", w.getMessage())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.dobj", 4, "Die Darstellung hat " + list.size() + " Parser Fehler", null);
            list.stream().forEach(s -> result.add((IStatus)s));
            return result;
        }
        return Status.OK_STATUS;
    }
}

