/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractTool;

class ViewPanTool
extends AbstractTool {
    public static final String PROP_ACTIVE = "active";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private Point startPunkt;

    ViewPanTool() {
        this.setDefaultCursor(Cursors.HAND);
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "pan";
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return viewer instanceof GraphicalViewer;
    }

    public void activate() {
        super.activate();
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, (Object)true);
    }

    public void deactivate() {
        super.deactivate();
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, (Object)false);
    }

    public boolean isActive() {
        return super.isActive();
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            this.startPunkt = new Point(this.getViewport().getHorizontalRangeModel().getValue(), this.getViewport().getVerticalRangeModel().getValue());
        } else {
            this.handleInvalidInput();
        }
        return true;
    }

    private Viewport getViewport() {
        return this.getZoomManager().getViewport();
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.getCurrentViewer().getProperty(ZoomManager.class.toString());
    }

    protected boolean handleDragInProgress() {
        if (this.startPunkt != null) {
            int divX = this.getStartLocation().x - this.getLocation().x;
            int divY = this.getStartLocation().y - this.getLocation().y;
            this.getViewport().setHorizontalLocation(this.startPunkt.x + divX);
            this.getViewport().setVerticalLocation(this.startPunkt.y + divY);
        } else {
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        this.startPunkt = null;
        return true;
    }

    protected boolean handleInvalidInput() {
        this.startPunkt = null;
        return super.handleInvalidInput();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

