/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import de.bsvrz.buv.plugin.darstellung.views.ansicht.ViewRectangleFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.util.DobjCursors;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractTool;

class ViewRectangleZoomTool
extends AbstractTool {
    public static final String PROP_ACTIVE = "active";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private ViewRectangleFeedbackFigure feedbackFigure;

    ViewRectangleZoomTool() {
        this.setDefaultCursor(DobjCursors.ZoomIn.getCursor());
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "zoom rectangle";
    }

    protected void handleFinished() {
        Rectangle ausschnitt = new Rectangle(this.getStartLocation(), this.getLocation());
        if (ausschnitt.getSize().height > 10 && ausschnitt.getSize().width > 10) {
            double currentZoom = this.getZoomManager().getZoom();
            PrecisionPoint ursprung = new PrecisionPoint((double)this.getViewport().getHorizontalRangeModel().getValue() / currentZoom + ausschnitt.getLocation().preciseX() / currentZoom, (double)this.getViewport().getVerticalRangeModel().getValue() / currentZoom + ausschnitt.getLocation().preciseY() / currentZoom);
            double xZoom = currentZoom / (ausschnitt.preciseWidth() / (double)this.getViewport().getHorizontalRangeModel().getExtent());
            double yZoom = currentZoom / (ausschnitt.preciseHeight() / (double)this.getViewport().getVerticalRangeModel().getExtent());
            if (Math.abs(currentZoom - xZoom) > Math.abs(currentZoom - yZoom)) {
                this.getZoomManager().setZoom(yZoom);
            } else {
                this.getZoomManager().setZoom(xZoom);
            }
            currentZoom = this.getZoomManager().getZoom();
            this.getViewport().setHorizontalLocation((int)Math.round(ursprung.preciseX() * currentZoom));
            this.getViewport().setVerticalLocation((int)Math.round(ursprung.preciseY() * currentZoom));
        }
        super.handleFinished();
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.getCurrentViewer().getProperty(ZoomManager.class.toString());
    }

    private Viewport getViewport() {
        return this.getZoomManager().getViewport();
    }

    private IFigure getFeedbackFigure() {
        if (this.feedbackFigure == null) {
            this.feedbackFigure = new ViewRectangleFeedbackFigure();
            this.addFeedback((IFigure)this.feedbackFigure);
        }
        return this.feedbackFigure;
    }

    protected void showFeedback() {
        Rectangle rect = this.getSelectionRectangle().getCopy();
        this.getFeedbackFigure().translateToRelative((Translatable)rect);
        this.getFeedbackFigure().setBounds(rect);
    }

    private Rectangle getSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected void eraseFeedback() {
        if (this.feedbackFigure != null) {
            this.removeFeedback((IFigure)this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }

    public void activate() {
        super.activate();
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, (Object)true);
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseFeedback();
        }
        super.deactivate();
        this.setState(0x40000000);
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, (Object)false);
    }

    public boolean isActive() {
        return super.isActive();
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showFeedback();
        }
        return true;
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        this.stateTransition(1, 4);
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseFeedback();
        }
        if (button == 1) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseFeedback();
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

