/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.EinstellungenContentProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractExportWizardPage
extends WizardPage {
    private final EClass eClass;
    private final EMFModellEinstellungen<?> einstellungen;
    private TreeViewer viewer;
    private Text directoryText;
    private ISelection preSelection;

    protected AbstractExportWizardPage(String pageName, EClass eClass, EMFModellEinstellungen<?> einstellungen) {
        super(pageName);
        this.eClass = eClass;
        this.einstellungen = einstellungen;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.createViewer(container);
        this.createDirectory(container);
        this.viewer.getControl().setFocus();
        this.setControl((Control)container);
    }

    private void createViewer(Composite container) {
        Label label = new Label(container, 0);
        label.setText(this.eClass.getName());
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 128).create());
        this.viewer = new TreeViewer(container, 2818);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create());
        this.viewer.setContentProvider((IContentProvider)new EinstellungenContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EmfLabelProvider());
        this.viewer.setInput(this.einstellungen);
        this.viewer.setSelection(this.getPreSelection(), true);
        this.viewer.addSelectionChangedListener(event -> this.updatePageComplete());
    }

    private void createDirectory(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Zielverzeichnis");
        this.directoryText = new Text(container, 2048);
        this.directoryText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.directoryText.addModifyListener(e -> this.updatePageComplete());
        Button fileChooseButton = new Button(container, 8);
        fileChooseButton.setText("Ausw\u00e4hlen");
        fileChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(AbstractExportWizardPage.this.getShell());
                dlg.setText(AbstractExportWizardPage.this.getTitle());
                dlg.setMessage(AbstractExportWizardPage.this.getDescription());
                String selected = dlg.open();
                if (selected != null) {
                    AbstractExportWizardPage.this.directoryText.setText(selected);
                    AbstractExportWizardPage.this.updatePageComplete();
                }
            }
        });
    }

    private void updatePageComplete() {
        if (this.viewer.getSelection().isEmpty()) {
            this.setErrorMessage("Sie m\u00fcssen mindestens ein zu exportierendes Objekt ausw\u00e4hlen.");
            this.setPageComplete(false);
        } else if (this.directoryText.getText().isEmpty()) {
            this.setErrorMessage("Sie m\u00fcssen das Verzeichnis angeben, in das die ausgew\u00e4hlten Objekte exportiert werden sollen.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getDirectory() {
        return this.directoryText.getText();
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public ISelection getPreSelection() {
        return this.preSelection;
    }

    public void setPreSelection(ISelection preSelection) {
        this.preSelection = preSelection;
    }
}

