/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.EinstellungenContentProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AnsichtNewWizardPage
extends WizardPage
implements ModifyListener,
ISelectionChangedListener {
    private Text name;
    private TreeViewer darstellung;

    public AnsichtNewWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Neue Ansicht");
        this.setDescription("Bitte geben Sie den Namen der neuen Ansicht und die zu verwendende Darstellung an.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createName(container);
        this.createDarstellung(container);
        this.name.setFocus();
        this.setControl((Control)container);
    }

    private void createName(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Name");
        this.name = new Text(parent, 2048);
        this.name.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.name.addModifyListener((ModifyListener)this);
    }

    private void createDarstellung(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Darstellung");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 128).create());
        this.darstellung = new TreeViewer(parent, 2820);
        this.darstellung.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.darstellung.setContentProvider((IContentProvider)new EinstellungenContentProvider());
        this.darstellung.setLabelProvider((IBaseLabelProvider)new EmfLabelProvider());
        this.darstellung.setInput((Object)DarstellungenEinstellungen.INSTANCE);
        this.darstellung.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updatePageComplete() {
        boolean complete = true;
        complete &= !this.name.getText().isEmpty();
        complete &= !this.darstellung.getSelection().isEmpty();
        this.setPageComplete(complete &= ((IStructuredSelection)this.darstellung.getSelection()).getFirstElement() instanceof Darstellung);
    }

    public Ansicht getAnsicht() {
        Ansicht ansicht = DarstellungFactory.eINSTANCE.createAnsicht();
        ansicht.setName(this.name.getText());
        ITreeSelection selection = (ITreeSelection)this.darstellung.getSelection();
        ansicht.setDarstellung((Darstellung)EcoreUtil.copy((EObject)((EObject)selection.getFirstElement())));
        return ansicht;
    }

    public void dispose() {
        this.name.removeModifyListener((ModifyListener)this);
        this.darstellung.removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public void modifyText(ModifyEvent e) {
        this.updatePageComplete();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updatePageComplete();
    }
}

