/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.actions;

import de.bsvrz.buv.plugin.dobj.actions.DobjActionFactory;
import de.bsvrz.buv.plugin.dobj.actions.DobjWorkbenchPartAction;
import de.bsvrz.buv.plugin.dobj.internal.DobjMessages;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.ui.IWorkbenchPart;

public class FixViewportAction
extends DobjWorkbenchPartAction {
    private final ControlListener controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            ZoomManager zm = FixViewportAction.this.getZoomManager();
            double newX = zm.getViewport().getHorizontalRangeModel().getExtent();
            double newY = zm.getViewport().getVerticalRangeModel().getExtent();
            if (FixViewportAction.this.aktiv) {
                double distX = newX - FixViewportAction.this.currentX;
                double distY = newY - FixViewportAction.this.currentY;
                if (FixViewportAction.this.currentX > -1.0 && FixViewportAction.this.currentY > -1.0 && distX != 0.0 && distY != 0.0) {
                    double originX = zm.getViewport().getHorizontalRangeModel().getValue();
                    double originY = zm.getViewport().getVerticalRangeModel().getValue();
                    double currentZoom = zm.getZoom();
                    double scale = 1.0;
                    if (Math.abs(distX) >= Math.abs(distY)) {
                        if (FixViewportAction.this.currentY != 0.0) {
                            scale = newY / FixViewportAction.this.currentY;
                        }
                    } else if (FixViewportAction.this.currentX != 0.0) {
                        scale = newX / FixViewportAction.this.currentX;
                    }
                    zm.setZoom(currentZoom * scale);
                    zm.getViewport().getHorizontalRangeModel().setValue((int)Math.abs(originX * scale));
                    zm.getViewport().getVerticalRangeModel().setValue((int)Math.abs(originY * scale));
                }
            }
            FixViewportAction.this.currentX = newX;
            FixViewportAction.this.currentY = newY;
        }
    };
    private boolean aktiv;
    private double currentX = -1.0;
    private double currentY = -1.0;

    public FixViewportAction(IWorkbenchPart part) {
        super(part, 2);
        this.setText(DobjMessages.toggleFixViewportLabel);
        this.setImageDescriptor(DobjIcons.ActionToggleFixViewport.getImageDescriptor());
        this.setToolTipText(DobjMessages.toggleFixViewportTooltip);
        this.setId(DobjActionFactory.TOGGLE_FIX_VIEWPORT.getCommandId());
        this.setActionDefinitionId(DobjActionFactory.TOGGLE_FIX_VIEWPORT.getCommandId());
        ZoomManager zm = this.getZoomManager();
        if (zm != null) {
            this.currentX = zm.getViewport().getHorizontalRangeModel().getExtent();
            this.currentY = zm.getViewport().getVerticalRangeModel().getExtent();
        }
        this.getViewer().getControl().addControlListener(this.controlListener);
    }

    @Override
    protected boolean calculateEnabled() {
        return super.calculateEnabled() && this.getZoomManager() != null;
    }

    public void run() {
        this.aktiv = this.isChecked();
    }

    public void dispose() {
        if (this.getViewer().getControl() != null) {
            this.getViewer().getControl().removeControlListener(this.controlListener);
        }
        super.dispose();
    }
}

