/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

abstract class ZustandsfarbenDecoratorPropertySection<T extends EObject>
extends AbstractSection<T> {
    private final Map<EStructuralFeature, Label> labels = new HashMap<EStructuralFeature, Label>();
    private final Map<EStructuralFeature, Text> colorTexts = new HashMap<EStructuralFeature, Text>();
    private final Map<EStructuralFeature, Button> selectColorButtons = new HashMap<EStructuralFeature, Button>();
    private final Map<EStructuralFeature, Button> useDefaultButtons = new HashMap<EStructuralFeature, Button>();
    private final Map<EStructuralFeature, Color> colors = new HashMap<EStructuralFeature, Color>();

    ZustandsfarbenDecoratorPropertySection() {
    }

    protected final Text createDatenstatusColor(final String zustand, final EStructuralFeature feature, final Composite parent, Control vorgaenger) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Label label = factory.createLabel(parent, zustand);
        Text colorText = factory.createText(parent, "", 8);
        colorText.setEditable(false);
        colorText.setEnabled(false);
        Button selectColorButton = factory.createButton(parent, "\u00c4ndern", 8);
        final Button useDefaultButton = factory.createButton(parent, "Defaultwert verwenden", 32);
        FormData textData = new FormData();
        textData.left = new FormAttachment((Control)label, 5);
        textData.width = 150;
        textData.top = vorgaenger != null ? new FormAttachment(vorgaenger, 4) : new FormAttachment(0, 6);
        colorText.setLayoutData((Object)textData);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.width = 170;
        formData.top = new FormAttachment((Control)colorText, 0, 0x1000000);
        label.setLayoutData((Object)formData);
        FormData selectColorData = new FormData();
        selectColorData.left = new FormAttachment((Control)colorText, 5);
        selectColorData.top = new FormAttachment((Control)colorText, 0, 0x1000000);
        selectColorButton.setLayoutData((Object)selectColorData);
        FormData useDefaultData = new FormData();
        useDefaultData.left = new FormAttachment((Control)selectColorButton, 0, 5);
        useDefaultData.top = new FormAttachment((Control)colorText, 0, 0x1000000);
        useDefaultButton.setLayoutData((Object)useDefaultData);
        selectColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dlg = new ColorDialog(parent.getShell());
                dlg.setText("Farbe f\u00fcr den Zustand \"" + zustand + "\" ausw\u00e4hlen");
                dlg.setRGB((RGB)ZustandsfarbenDecoratorPropertySection.this.getElement().eGet(feature));
                RGB color = dlg.open();
                if (color != null) {
                    SetCommand command = new SetCommand(ZustandsfarbenDecoratorPropertySection.this.getElement(), feature, (Object)color);
                    ZustandsfarbenDecoratorPropertySection.this.getCommandStack().execute((Command)command);
                }
            }
        });
        useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (useDefaultButton.getSelection()) {
                    UnsetCommand cmd = new UnsetCommand(ZustandsfarbenDecoratorPropertySection.this.getElement(), feature);
                    ZustandsfarbenDecoratorPropertySection.this.getCommandStack().execute((Command)cmd);
                } else {
                    RGB value = (RGB)ZustandsfarbenDecoratorPropertySection.this.getElement().eGet(feature);
                    SetCommand cmd = new SetCommand(ZustandsfarbenDecoratorPropertySection.this.getElement(), feature, (Object)value);
                    ZustandsfarbenDecoratorPropertySection.this.getCommandStack().execute((Command)cmd);
                }
            }
        });
        this.labels.put(feature, label);
        this.colorTexts.put(feature, colorText);
        this.selectColorButtons.put(feature, selectColorButton);
        this.useDefaultButtons.put(feature, useDefaultButton);
        return colorText;
    }

    public void refresh() {
        this.disposeColors();
        this.setColors();
    }

    private void disposeColors() {
        for (Color c : this.colors.values()) {
            c.dispose();
        }
    }

    private void setColors() {
        for (EStructuralFeature feature : this.colorTexts.keySet()) {
            Color color = this.setColor(feature);
            this.colors.put(feature, color);
        }
    }

    private Color setColor(EStructuralFeature feature) {
        Label label = this.labels.get(feature);
        Text text = this.colorTexts.get(feature);
        Button selectColorButton = this.selectColorButtons.get(feature);
        Button useDefaultButton = this.useDefaultButtons.get(feature);
        RGB rgb = (RGB)this.getElement().eGet(feature);
        Color color = new Color((Device)text.getDisplay(), rgb);
        text.setText(rgb.toString());
        text.setBackground(color);
        boolean useDefault = !this.getElement().eIsSet(feature);
        useDefaultButton.setSelection(useDefault);
        boolean enabled = !useDefault;
        label.setEnabled(enabled);
        selectColorButton.setEnabled(enabled);
        return color;
    }

    @Override
    public void dispose() {
        this.disposeColors();
        super.dispose();
    }
}

