/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.ResizeDoModelCommand;
import de.bsvrz.buv.plugin.dobj.decorator.ZoomVerhaltenFixMediator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.figures.DoBildFigure;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class DoBildEditPart
extends DoModelEditPart<DoBild, DoBildFigure> {
    protected DoBildFigure createFigure() {
        return new DoBildFigure(this.getResourceManager());
    }

    @Override
    protected IFigure getToolTip() {
        return null;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new BildResizableEditPolicy());
        if (!this.isEditor()) {
            this.removeEditPolicy("LayoutEditPolicy");
        }
    }

    @Override
    public boolean isSelectable() {
        return this.isEditor() || super.isSelectable() && ((DoBild)this.getModel()).isSelektierbar();
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (DobjDecoratorPackage.Literals.ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX.equals(notification.getFeature()) && notification.getNewBooleanValue() != notification.getOldBooleanValue()) {
            double zoom = this.getZoomManager().getZoom();
            Dimension size = ((DoBild)this.getModel()).getSize();
            if (size == null) {
                size = new Dimension(100, 100);
            }
            if (notification.getNewBooleanValue()) {
                ((DoBild)this.getModel()).setSize(size.getScaled(zoom));
            } else {
                ((DoBild)this.getModel()).setSize(size.getScaled(1.0 / zoom));
            }
        } else if (GefPackage.Literals.SIZED__SIZE.equals(notification.getFeature()) || DobjPackage.Literals.DO_BILD__BILD.equals(notification.getFeature())) {
            this.refreshVisuals();
        }
    }

    @Override
    protected void refreshVisuals() {
        new ZoomVerhaltenFixMediator(this).mediate();
        if (((DoBild)this.getModel()).getSize() != null) {
            ((DoBildFigure)this.getFigure()).setSize(((DoBild)this.getModel()).getSize().getCopy());
        } else {
            ((DoBildFigure)this.getFigure()).setSize(new Dimension(100, 100));
        }
        if (((DoBild)this.getModel()).getBild() != null) {
            ((DoBildFigure)this.getFigure()).setBild(((DoBild)this.getModel()).getBild());
        }
        super.refreshVisuals();
    }

    private final class BildResizableEditPolicy
    extends ResizableEditPolicy {
        private BildResizableEditPolicy() {
        }

        protected Command getMoveCommand(ChangeBoundsRequest request) {
            return new MoveDoModelCommand((DoModel)DoBildEditPart.this.getModel(), ((DoBildFigure)DoBildEditPart.this.getFigure()).getHotspot().getCopy().getTranslated(request.getMoveDelta().getScaled(1.0 / DoBildEditPart.this.getZoomManager().getZoom())));
        }

        protected Command getResizeCommand(ChangeBoundsRequest request) {
            PrecisionDimension size = new PrecisionDimension(((DoBildFigure)DoBildEditPart.this.getFigure()).getSize());
            size.performScale(DoBildEditPart.this.getZoomManager().getZoom());
            CompoundCommand command = new CompoundCommand("Bild Verschieben und Skalieren");
            if (size.isEmpty()) {
                size = new PrecisionDimension(100.0, 100.0);
            }
            if (((DoBild)DoBildEditPart.this.getModel()).isZoomVerhaltenFix()) {
                command.add((Command)new ResizeDoModelCommand((DoModel)DoBildEditPart.this.getModel(), size.getExpanded(request.getSizeDelta())));
            } else {
                command.add(super.getResizeCommand(request));
            }
            command.add(this.getMoveCommand(request));
            return command;
        }
    }
}

