/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import de.bsvrz.buv.plugin.darstellung.editparts.EbeneEditPart;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.DoMediator;
import de.bsvrz.buv.plugin.dobj.editparts.BaseGraphicalEditPart;
import de.bsvrz.buv.plugin.dobj.editpolicies.MqAlsLinieSelectionEditPolicy;
import de.bsvrz.buv.plugin.dobj.figures.SystemObjectToolTipFigure;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import de.bsvrz.buv.plugin.dobj.requests.BaustelleGueltigRequest;
import de.bsvrz.buv.plugin.dobj.requests.KollisionsAlgorithmusRequest;
import de.bsvrz.buv.plugin.dobj.requests.OnlineRequest;
import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;

public abstract class DoModelEditPart<T extends DoModel, F extends IFigure>
extends BaseGraphicalEditPart<T, F>
implements ZoomListener {
    private static Set<TypeAtgKey> cachedData = new HashSet<TypeAtgKey>();
    private static final Debug LOGGER = Debug.getLogger();
    private boolean antikollisionsalgorithmus = true;
    private boolean nurGueltigeBaustellenAnzeigen = true;
    private boolean online;
    private SystemObjectToolTipFigure toolTip;

    public IDavZeitStempelManager getDavZeitStempelManager() {
        return (IDavZeitStempelManager)this.getViewer().getProperty(IDavZeitStempelManager.class.toString());
    }

    public KollisionsManager getKollisionsManager() {
        return (KollisionsManager)this.getViewer().getProperty(KollisionsManager.class.toString());
    }

    public boolean isAntikollisionsalgorithmus() {
        return this.antikollisionsalgorithmus;
    }

    public boolean isNurGueltigeBaustellenAnzeigen() {
        return this.nurGueltigeBaustellenAnzeigen;
    }

    public Projektion getProjektion() {
        if (this.getViewer() == null) {
            return Projektion.NULL;
        }
        return (Projektion)this.getViewer().getProperty(Projektion.class.toString());
    }

    protected void createEditPolicies() {
        if (!this.isEditor()) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MqAlsLinieSelectionEditPolicy());
        }
    }

    public void activate() {
        super.activate();
        ((DoModel)this.getModel()).getDoTyp().eAdapters().add((Object)this);
        if (this.getFigure().getToolTip() == null) {
            this.getFigure().setToolTip(this.getToolTip());
        }
        if (((DoModel)this.getModel()).getRelativZu() != null) {
            ((DoModel)this.getModel()).getRelativZu().eAdapters().add((Object)this);
        }
        this.getEbeneDoTyp((EditPart)this).stream().forEach(t -> {
            boolean bl = t.eAdapters().add((Object)this);
        });
        this.getZoomManager().addZoomListener((ZoomListener)this);
        if (!(this.getFigure() instanceof DoFigure)) {
            this.refreshZoom();
        }
    }

    public void deactivate() {
        this.performRequest(new OnlineRequest(false));
        this.getZoomManager().removeZoomListener((ZoomListener)this);
        if (((DoModel)this.getModel()).getRelativZu() != null) {
            ((DoModel)this.getModel()).getRelativZu().eAdapters().remove((Object)this);
        }
        ((DoModel)this.getModel()).getDoTyp().eAdapters().remove((Object)this);
        this.getEbeneDoTyp((EditPart)this).stream().forEach(t -> {
            boolean bl = t.eAdapters().remove((Object)this);
        });
        super.deactivate();
    }

    private List<DoTyp> getEbeneDoTyp(EditPart part) {
        EditPart parent = part.getParent();
        if (parent instanceof EbeneEditPart) {
            EbeneEditPart ebene = (EbeneEditPart)parent;
            DoTyp doTypDarstellung = ((DoModel)this.getModel()).getDoTyp();
            Optional<DoTyp> optional = ((Ebene)ebene.getModel()).getEbeneDoTypen().stream().filter(t -> Objects.equals(t.getId(), doTypDarstellung.getId())).findFirst();
            ArrayList<DoTyp> result = new ArrayList<DoTyp>();
            optional.ifPresent(result::add);
            result.addAll(this.getEbeneDoTyp((EditPart)ebene));
            return result;
        }
        return new ArrayList<DoTyp>();
    }

    public void performRequest(Request req) {
        super.performRequest(req);
        if ("Online".equals(req.getType())) {
            this.performOnlineRequest((OnlineRequest)req);
        } else if ("Kollisionsalgorithmus".equals(req.getType())) {
            this.performKollisionsAlgorithmusRequest((KollisionsAlgorithmusRequest)req);
        } else if ("Baustellegueltig".equals(req.getType())) {
            this.performBaustelleGueltigRequest((BaustelleGueltigRequest)req);
        }
    }

    private void performOnlineRequest(OnlineRequest req) {
        if (req.isOnline()) {
            if (!this.online) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        DoModelEditPart.this.geheOnline();
                        DoModelEditPart.this.online = true;
                    }

                    public void handleException(Throwable exception) {
                        DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Fehler beim Online gehen " + String.valueOf(DoModelEditPart.this.getModel()), exception));
                    }
                });
            }
        } else if (this.online) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    DoModelEditPart.this.geheOffline();
                    DoModelEditPart.this.online = false;
                }

                public void handleException(Throwable exception) {
                    DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Fehler beim Offline gehen " + String.valueOf(DoModelEditPart.this.getModel()), exception));
                }
            });
        }
    }

    private void performKollisionsAlgorithmusRequest(KollisionsAlgorithmusRequest kar) {
        this.antikollisionsalgorithmus = kar.isKollisionsAlgorithmusAn();
        this.refreshVisuals();
    }

    private void performBaustelleGueltigRequest(BaustelleGueltigRequest bstg) {
        this.nurGueltigeBaustellenAnzeigen = bstg.isAlleGueltigenBaustellenAnzeigen();
        this.refreshVisuals();
    }

    protected boolean isOnline() {
        return this.online;
    }

    protected void geheOnline() {
    }

    protected void geheOffline() {
    }

    public void notifyChanged(Notification notification) {
        block22: {
            int type;
            Object notifier;
            block21: {
                notifier = notification.getNotifier();
                type = notification.getEventType();
                if (!(notifier instanceof DoModel)) break block21;
                int featureID = notification.getFeatureID(DoModel.class);
                block0 : switch (type) {
                    case 1: {
                        switch (featureID) {
                            case 5: {
                                if (notification.getOldValue() == null && ((DoModel)this.getModel()).getRelativZu() != null) {
                                    ((DoModel)this.getModel()).getRelativZu().eAdapters().add((Object)this);
                                    break;
                                }
                                if (notification.getOldValue() != null && ((DoModel)this.getModel()).getRelativZu() == null) {
                                    ((DoModel)notification.getOldValue()).eAdapters().remove((Object)this);
                                    break;
                                }
                                break block22;
                            }
                            case 0: 
                            case 1: 
                            case 4: 
                            case 6: {
                                this.refreshVisuals();
                            }
                        }
                        break block22;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        switch (featureID) {
                            case 7: {
                                this.refreshSourceConnections();
                                break block0;
                            }
                            case 8: {
                                this.refreshTargetConnections();
                            }
                        }
                    }
                }
                break block22;
            }
            if (notifier instanceof DoTyp) {
                int featureID = notification.getFeatureID(DoModel.class);
                switch (type) {
                    case 1: {
                        switch (featureID) {
                            case 5: {
                                this.refreshVisuals();
                            }
                        }
                    }
                }
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                if (DoModelEditPart.this.getFigure() instanceof DoFigure) {
                    new DoMediator(DoModelEditPart.this).mediate();
                } else {
                    DoModelEditPart.this.refreshLocation();
                    DoModelEditPart.this.refreshZoom();
                }
            }

            public void handleException(Throwable exception) {
                DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Aktualisierung der Eigenschaften f\u00fcr Darstellungsobjekt " + String.valueOf(DoModelEditPart.this.getModel()) + " nicht m\u00f6glich.", exception));
            }
        });
        this.refreshTooltip();
    }

    private void refreshLocation() {
        Point location;
        if (!(this.getFigure() instanceof DoFigure) && (location = ((DoModel)this.getModel()).getAbsoluteLocation()) != null) {
            IFigure f = this.getFigure();
            f.setLocation(location);
            this.updateLayoutConstraint();
        }
    }

    private void updateLayoutConstraint() {
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        IFigure f = this.getFigure();
        parent.setLayoutConstraint((EditPart)this, f, (Object)f.getBounds());
    }

    private void refreshZoom() {
        this.zoomChanged(this.getZoomManager().getZoom());
    }

    private void refreshTooltip() {
        if (this.toolTip != null) {
            this.toolTip.setSystemObject(((DoModel)this.getModel()).getSystemObject());
            if (((DoModel)this.getModel()).getName() != null && !((DoModel)this.getModel()).getName().isEmpty()) {
                this.toolTip.setName(((DoModel)this.getModel()).getName());
            }
        }
    }

    public void zoomChanged(double zoom) {
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof DoFigure) {
            DoFigure doFigure = (DoFigure)iFigure;
            doFigure.handleZoomChanged(zoom);
        } else {
            ZoomStufe zoomStufe = ((DoModel)this.getModel()).getDoTyp().getZoomStufe();
            if (zoomStufe != null) {
                double min = zoomStufe.getVonLevel();
                double max = zoomStufe.getBisLevel();
                double readableZoom = zoom * this.getZoomManager().getUIMultiplier();
                this.getFigure().setVisible((min /= 100.0) <= readableZoom && readableZoom <= (max /= 100.0));
            } else {
                this.getFigure().setVisible(true);
            }
        }
    }

    protected IFigure getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new SystemObjectToolTipFigure(((DoModel)this.getModel()).getSystemObject());
        }
        return this.toolTip;
    }

    protected void vorladen(String typePid, String atgPid) {
        TypeAtgKey cached = new TypeAtgKey(typePid, atgPid);
        if (cachedData.contains(cached)) {
            return;
        }
        long t = System.currentTimeMillis();
        ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
        DataModel dataModel = dav.getDataModel();
        SystemObjectType systemObjectType = dataModel.getType(typePid);
        AttributeGroup atg = dataModel.getAttributeGroup(atgPid);
        dataModel.getConfigurationData((Collection)systemObjectType.getObjects(), atg);
        cachedData.add(cached);
        t = System.currentTimeMillis() - t;
        LOGGER.fine(((Object)((Object)this)).getClass().getSimpleName() + "#vorladen(" + typePid + ", " + atgPid + "): " + t / 1000L + " Sekunden");
    }

    public boolean isSelectable() {
        if ((this.getEditorType() & 1) == 1) {
            return false;
        }
        return this.getFigure().isShowing() && super.isSelectable();
    }

    public Darstellung getDarstellung() {
        return this.getDarstellung((EditPart)this);
    }

    private Darstellung getDarstellung(EditPart part) {
        EditPart parent = part.getParent();
        if (parent == null) {
            return null;
        }
        Object parentModel = parent.getModel();
        if (parentModel instanceof Darstellung) {
            Darstellung darstellung = (Darstellung)parentModel;
            return darstellung;
        }
        return this.getDarstellung(parent);
    }

    protected List<?> getModelSourceConnections() {
        return ((DoModel)this.getModel()).getAusgehendeVerbindungen();
    }

    protected List<?> getModelTargetConnections() {
        return ((DoModel)this.getModel()).getEingehendeVerbindungen();
    }

    public String getSuchText() {
        SystemObject systemObject = ((DoModel)this.getModel()).getSystemObject();
        if (systemObject == null) {
            return ((DoModel)this.getModel()).getName();
        }
        return systemObject.getNameOrPidOrId();
    }

    record TypeAtgKey(String typePid, String atgPid) {
    }
}

