/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.editparts.GeoRefererenzObjektEditPart;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Koordinate;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public abstract class PunktEditPart<T extends Punkt, F extends IFigure>
extends GeoRefererenzObjektEditPart<T, F> {
    private static final Debug LOGGER = Debug.getLogger();
    private Point wgs84Location;
    private Point location;

    @Override
    protected void cleanModellKoordinaten() {
        this.location = null;
    }

    protected Point getWgs84Location() {
        if (this.wgs84Location == null) {
            Punkt p = (Punkt)((BitCtrlDoModel)this.getModel()).getSystemObjekt();
            try {
                WGS84Koordinate wgs84 = WGS84Util.konvertiere((Punkt)p);
                this.wgs84Location = new PrecisionPoint(wgs84.getLaenge(), wgs84.getBreite());
            }
            catch (RuntimeException ex) {
                LOGGER.error("Die WGS-84-Koordinaten des Punkts konnten nicht bestimmt werden: " + String.valueOf(p), (Throwable)ex);
            }
        }
        return this.wgs84Location;
    }

    protected Point getLocation() {
        if (this.location == null) {
            Projektion projektion = this.getProjektion();
            Point wgs84 = this.getWgs84Location();
            this.location = projektion != null && wgs84 != null ? projektion.umrechnenWeltNachModel(wgs84) : wgs84;
        }
        return this.location;
    }

    protected Point[] getStreckenAbschnitt() {
        if (this.getProjektion() != null && ((BitCtrlDoModel)this.getModel()).getSystemObjekt() instanceof PunktLiegtAufLinienObjekt) {
            WGS84Polygon teilstrecke;
            PunktLiegtAufLinienObjekt p = (PunktLiegtAufLinienObjekt)((BitCtrlDoModel)this.getModel()).getSystemObjekt();
            if (p != null && p.getKdPunktLiegtAufLinienObjekt() != null && p.getKdPunktLiegtAufLinienObjekt().getDatum() != null && ((KdPunktLiegtAufLinienObjekt.Daten)p.getKdPunktLiegtAufLinienObjekt().getDatum()).getOffset() != null) {
                teilstrecke = WGS84Util.getLinie((PunktLiegtAufLinienObjekt)p);
                if (teilstrecke.laenge() == 0.0) {
                    return null;
                }
                double l = ((KdPunktLiegtAufLinienObjekt.Daten)p.getKdPunktLiegtAufLinienObjekt().getDatum()).getOffset().doubleValue();
                ArrayList<WGS84Punkt> pAbstandDummyPunkte = new ArrayList<WGS84Punkt>();
                ArrayList punkteAufLinie = teilstrecke.getKoordinaten();
                double laengeBisJetzt = 0.0;
                if (punkteAufLinie.size() > 1) {
                    int i = 0;
                    while (i < punkteAufLinie.size() - 1) {
                        double laengeAufAbschnitt;
                        pAbstandDummyPunkte.clear();
                        pAbstandDummyPunkte.add((WGS84Punkt)punkteAufLinie.get(i));
                        pAbstandDummyPunkte.add((WGS84Punkt)punkteAufLinie.get(i + 1));
                        WGS84Polygon pAbstandDummy = new WGS84Polygon(pAbstandDummyPunkte);
                        double abstand = pAbstandDummy.laenge();
                        if (l >= laengeBisJetzt && l <= laengeBisJetzt + abstand && (laengeAufAbschnitt = l - laengeBisJetzt) > 0.0 && abstand > 0.0) {
                            double p1YNeu;
                            WGS84Punkt wgsP1 = (WGS84Punkt)punkteAufLinie.get(i);
                            WGS84Punkt wgsP2 = (WGS84Punkt)punkteAufLinie.get(i + 1);
                            Point p1 = this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(wgsP1.getLaenge(), wgsP1.getBreite()));
                            Point p2 = this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(wgsP2.getLaenge(), wgsP2.getBreite()));
                            double xDiff = p2.preciseX() - p1.preciseX();
                            double yDiff = p2.preciseY() - p1.preciseY();
                            double verhaeltnis = laengeAufAbschnitt / abstand;
                            double p1XNeu = p1.preciseX() + xDiff * verhaeltnis;
                            Point p1Neu = new Point((int)p1XNeu, (int)(p1YNeu = p1.preciseY() + yDiff * verhaeltnis));
                            if (!p1Neu.equals((Object)p2)) {
                                return new Point[]{p1Neu, p2};
                            }
                        }
                        laengeBisJetzt += abstand;
                        ++i;
                    }
                }
            }
            try {
                teilstrecke = WGS84Util.findTeilstrecke((PunktLiegtAufLinienObjekt)p);
                Point[] g = new Point[]{this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(teilstrecke[0].getLaenge(), teilstrecke[0].getBreite())), this.getProjektion().umrechnenWeltNachModel((Point)new PrecisionPoint(teilstrecke[1].getLaenge(), teilstrecke[1].getBreite()))};
                return g;
            }
            catch (RuntimeException ex) {
                LOGGER.fine("Der Streckenabschnitt auf dem der Punkt liegt kann nicht bestimmt werden", (Object)p);
            }
        }
        return null;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (((BitCtrlDoModel)this.getModel()).getSystemObject() != null && ((BitCtrlDoModel)this.getModel()).getLocation() == null && this.getProjektion() != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IFigure f = PunktEditPart.this.getFigure();
                    Point p = PunktEditPart.this.getLocation();
                    if (f instanceof DoFigure) {
                        DoFigure doFigure = (DoFigure)f;
                        doFigure.setHotspot(p);
                    } else {
                        f.setLocation(p);
                    }
                }

                public void handleException(Throwable exception) {
                    DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Bestimmung der Position f\u00fcr " + String.valueOf(PunktEditPart.this.getModel()) + " nicht m\u00f6glich.", exception));
                }
            });
        }
    }
}

