/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.graph;

import com.bitctrl.graph.AbstractGraph;
import com.bitctrl.graph.Bogen;
import com.bitctrl.graph.Knoten;
import de.bsvrz.buv.plugin.dobj.graph.NetzBogen;
import de.bsvrz.buv.plugin.dobj.graph.NetzKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.NetzBestandTeil;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetzGraph
extends AbstractGraph {
    private static final Debug LOGGER = Debug.getLogger();
    private final Netz netz;
    private final Map<StrassenKnoten, Knoten> knotenListe = new HashMap<StrassenKnoten, Knoten>();
    private final Map<AeusseresStrassenSegment, Bogen> bogenListe = new HashMap<AeusseresStrassenSegment, Bogen>();

    public NetzGraph(Netz netz) {
        this.netz = netz;
        this.init(netz);
    }

    public Netz getNetz() {
        return this.netz;
    }

    private void init(Netz n) {
        for (NetzBestandTeil nbt : n.getNetzBestandTeile()) {
            if (nbt instanceof Netz) {
                this.init((Netz)nbt);
                continue;
            }
            if (nbt instanceof AeusseresStrassenSegment) {
                AeusseresStrassenSegment aess = (AeusseresStrassenSegment)nbt;
                KdAeusseresStrassenSegment.Daten datum = (KdAeusseresStrassenSegment.Daten)aess.getKdAeusseresStrassenSegment().getDatum();
                if (datum != null) {
                    StrassenKnoten vonKnoten = datum.getVonKnoten();
                    NetzKnoten anfangsKnoten = null;
                    if (vonKnoten != null) {
                        if (!this.knotenListe.containsKey(vonKnoten)) {
                            anfangsKnoten = new NetzKnoten(vonKnoten);
                            this.knotenListe.put(vonKnoten, (Knoten)anfangsKnoten);
                        } else {
                            anfangsKnoten = (NetzKnoten)this.knotenListe.get(vonKnoten);
                        }
                    }
                    StrassenKnoten nachKnoten = datum.getNachKnoten();
                    NetzKnoten endKnoten = null;
                    if (nachKnoten != null) {
                        if (!this.knotenListe.containsKey(nachKnoten)) {
                            endKnoten = new NetzKnoten(nachKnoten);
                            this.knotenListe.put(nachKnoten, (Knoten)endKnoten);
                        } else {
                            endKnoten = (NetzKnoten)this.knotenListe.get(nachKnoten);
                        }
                    }
                    this.bogenListe.put(aess, new NetzBogen(aess, anfangsKnoten, endKnoten));
                    continue;
                }
                LOGGER.warning("\u00c4u\u00dferes Stra\u00dfensegment ist nicht vollst\u00e4ndig konfiguriert und wird deshalb ignoriert:", (Object)aess);
                continue;
            }
            throw new IllegalStateException("Unbekanntes NetzBestandTeil: " + String.valueOf(nbt));
        }
        for (Knoten knoten : this.getKnoten()) {
            ((NetzKnoten)knoten).init(this);
        }
    }

    public NetzKnoten getKnoten(StrassenKnoten strassenKnoten) {
        return (NetzKnoten)this.knotenListe.get(strassenKnoten);
    }

    public Set<Knoten> getKnoten() {
        return Collections.unmodifiableSet(new HashSet<Knoten>(this.knotenListe.values()));
    }

    public NetzBogen getBogen(AeusseresStrassenSegment aeusseresStrassenSegment) {
        return (NetzBogen)this.bogenListe.get(aeusseresStrassenSegment);
    }

    public Collection<Bogen> getBoegen() {
        return Collections.unmodifiableSet(new HashSet<Bogen>(this.bogenListe.values()));
    }
}

