/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.graph;

import com.bitctrl.graph.AbstractKnoten;
import com.bitctrl.graph.Bogen;
import de.bsvrz.buv.plugin.dobj.graph.NetzBogen;
import de.bsvrz.buv.plugin.dobj.graph.NetzGraph;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetzKnoten
extends AbstractKnoten {
    private static final Debug LOGGER = Debug.getLogger();
    private final StrassenKnoten strassenKnoten;
    private final Set<Bogen> eingangsBogenListe = new HashSet<Bogen>();
    private final Set<Bogen> ausgangsBogenListe = new HashSet<Bogen>();
    private final Set<Bogen> inzidentBogenListe = new HashSet<Bogen>();
    private final Map<NetzKnotenKey, InneresStrassenSegment> innereStrassenSegmente = new HashMap<NetzKnotenKey, InneresStrassenSegment>();

    NetzKnoten(StrassenKnoten strassenKnoten) {
        this.strassenKnoten = strassenKnoten;
    }

    public StrassenKnoten getStrassenKnoten() {
        return this.strassenKnoten;
    }

    public InneresStrassenSegment getInneresStrassenSegment(AeusseresStrassenSegment vonStrassenSegment, AeusseresStrassenSegment nachStrassenSegment) {
        return this.innereStrassenSegmente.get(new NetzKnotenKey(vonStrassenSegment, nachStrassenSegment));
    }

    void init(NetzGraph graph) {
        this.eingangsBogenListe.clear();
        this.ausgangsBogenListe.clear();
        this.inzidentBogenListe.clear();
        for (InneresStrassenSegment iss : this.strassenKnoten.getInnereStrassenSegmente()) {
            NetzBogen bogen;
            AeusseresStrassenSegment vonStrassenSegment;
            NetzBogen bogen2;
            KdInneresStrassenSegment.Daten issDatum = (KdInneresStrassenSegment.Daten)iss.getKdInneresStrassenSegment().getDatum();
            if (issDatum == null) {
                LOGGER.warning("Inneres Stra\u00dfensegment ist nicht vollst\u00e4ndig konfiguriert und wird deshalb ignoriert:", (Object)iss);
                continue;
            }
            AeusseresStrassenSegment nachStrassenSegment = issDatum.getNachStrassenSegment();
            if (nachStrassenSegment != null && (bogen2 = graph.getBogen(nachStrassenSegment)) != null && this.equals(bogen2.getAnfangsKnoten())) {
                this.ausgangsBogenListe.add(bogen2);
                this.inzidentBogenListe.add(bogen2);
            }
            if ((vonStrassenSegment = issDatum.getVonStrassenSegment()) != null && (bogen = graph.getBogen(vonStrassenSegment)) != null) {
                if (this.equals(bogen.getEndKnoten())) {
                    this.eingangsBogenListe.add(bogen);
                    this.inzidentBogenListe.add(bogen);
                } else {
                    System.err.println("Endknoten des Eingangsbogen ist falsch: " + String.valueOf(bogen));
                }
            }
            if (vonStrassenSegment != null && nachStrassenSegment != null) {
                this.innereStrassenSegmente.put(new NetzKnotenKey(vonStrassenSegment, nachStrassenSegment), iss);
            }
            if (vonStrassenSegment != null || nachStrassenSegment != null) continue;
            System.err.println("Knoten ohne inzidente B\u00f6gen: " + String.valueOf((Object)this));
        }
    }

    public Iterable<Bogen> ausgangsBogenIterator() {
        return this.ausgangsBogenListe;
    }

    public Iterable<Bogen> eingangsBogenIterator() {
        return this.eingangsBogenListe;
    }

    public Iterable<Bogen> inzidentBogenIterator() {
        return this.inzidentBogenListe;
    }

    public void setStuetzBogen(Bogen stuetzBogen) {
        if (stuetzBogen == null || stuetzBogen == WURZEL_BOGEN) {
            super.setStuetzBogen(stuetzBogen);
            return;
        }
        if (!this.equals(stuetzBogen.getEndKnoten())) {
            throw new IllegalArgumentException("Der St\u00fctzbogen muss zu diesem Knotenf\u00fchren.");
        }
        AeusseresStrassenSegment nachStrassenSegment = ((NetzBogen)stuetzBogen).getAeusseresStrassenSegment();
        NetzKnoten lastKnoten = (NetzKnoten)stuetzBogen.getAnfangsKnoten();
        Bogen lastStuetzBogen = lastKnoten.getStuetzBogen();
        if (lastStuetzBogen == null || lastStuetzBogen == WURZEL_BOGEN) {
            super.setStuetzBogen(stuetzBogen);
            return;
        }
        AeusseresStrassenSegment vonStrassenSegment = ((NetzBogen)lastStuetzBogen).getAeusseresStrassenSegment();
        if (lastKnoten.getInneresStrassenSegment(vonStrassenSegment, nachStrassenSegment) != null) {
            super.setStuetzBogen(stuetzBogen);
        } else {
            System.err.println("Ung\u00fcltiger St\u00fctzbogen wird ignoriert.");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NetzKnoten) {
            NetzKnoten other = (NetzKnoten)((Object)obj);
            return this.strassenKnoten.equals(other.strassenKnoten);
        }
        return false;
    }

    public int hashCode() {
        return this.strassenKnoten.hashCode();
    }

    public String toString() {
        return this.strassenKnoten.toString();
    }

    private record NetzKnotenKey(AeusseresStrassenSegment von, AeusseresStrassenSegment nach) {
    }
}

