/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.internal;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;

public final class DarstellungExtensionPoint {
    public static final String EXTENSION_POINT_ID = "de.bsvrz.buv.plugin.dobj.darstellung";
    public static final String ELEMENT_DARSTELLUNGS_OBJEKT_TYP = "darstellungsObjektTyp";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_DESCRIPTION = "description";
    public static final String ATT_SYSTEM_OBJEKT_TYP = "systemObjektTyp";
    public static final String ATT_MODEL_CLASS = "modelClass";
    public static final String ATT_CLASS = "class";
    public static final String ATT_CONTROLLER_CLASS = "controllerClass";
    public static final String ATT_ICON = "icon";
    public static final String ATT_NUR_MASSSTAEBLICHE_DARSTELLUNG = "nurMassstaeblicheDarstellung";

    public static ConfiguratedDoTyp getDoTyp(String id) {
        IConfigurationElement[] elements;
        if (id == null) {
            throw new IllegalArgumentException("Argument darf nicht null sein.");
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String att;
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (ELEMENT_DARSTELLUNGS_OBJEKT_TYP.equals(e.getName()) && (att = e.getAttribute(ATT_ID)) != null && att.equals(id)) {
                return DarstellungExtensionPoint.createDoTyp(e);
            }
            ++n2;
        }
        return null;
    }

    private static ConfiguratedDoTyp createDoTyp(IConfigurationElement e) {
        ConfiguratedDoTyp doTyp;
        String clazz = e.getAttribute(ATT_CLASS);
        if (clazz != null) {
            int index = clazz.lastIndexOf(47);
            doTyp = (ConfiguratedDoTyp)EmfUtil.createEObject((String)clazz.substring(0, index), (String)clazz.substring(index + 1));
        } else {
            doTyp = DobjFactory.eINSTANCE.createConfiguratedDoTyp();
        }
        doTyp.setConfigurationElement(e);
        return doTyp;
    }

    public static Collection<ConfiguratedDoTyp> getDoTypen() {
        IConfigurationElement[] elements;
        ArrayList<ConfiguratedDoTyp> typen = new ArrayList<ConfiguratedDoTyp>();
        IExtensionRegistry extension = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (ELEMENT_DARSTELLUNGS_OBJEKT_TYP.equals(e.getName())) {
                ConfiguratedDoTyp doTyp = DarstellungExtensionPoint.createDoTyp(e);
                String systemObjektTypPid = e.getAttribute(ATT_SYSTEM_OBJEKT_TYP);
                if (DarstellungExtensionPoint.isEmptyOrNull(systemObjektTypPid) || doTyp.getSystemObjectType() != null) {
                    typen.add(doTyp);
                }
            }
            ++n2;
        }
        return typen;
    }

    private static boolean isEmptyOrNull(String systemObjektTypPid) {
        return systemObjektTypPid == null || systemObjektTypPid.trim().isEmpty();
    }

    public static Collection<ConfiguratedDoTyp> getDoTypenWithExactMatch(SystemObjectType systemObjectType) {
        if (systemObjectType == null) {
            throw new IllegalArgumentException("Argument darf nicht null sein.");
        }
        ArrayList<ConfiguratedDoTyp> filteredTypen = new ArrayList<ConfiguratedDoTyp>();
        for (ConfiguratedDoTyp doTyp : DarstellungExtensionPoint.getDoTypen()) {
            if (!systemObjectType.equals(doTyp.getSystemObjectType())) continue;
            filteredTypen.add(doTyp);
        }
        return filteredTypen;
    }

    public static Collection<ConfiguratedDoTyp> getDoTypen(SystemObjectType systemObjectType) {
        if (systemObjectType == null) {
            throw new IllegalArgumentException("Argument darf nicht null sein.");
        }
        ArrayList<ConfiguratedDoTyp> filteredTypen = new ArrayList<ConfiguratedDoTyp>();
        for (ConfiguratedDoTyp doTyp : DarstellungExtensionPoint.getDoTypen()) {
            if (!systemObjectType.equals(doTyp.getSystemObjectType()) && !systemObjectType.getSuperTypes().contains(doTyp.getSystemObjectType())) continue;
            filteredTypen.add(doTyp);
        }
        return filteredTypen;
    }

    private DarstellungExtensionPoint() {
    }
}

