/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.kollision;

import de.bsvrz.buv.plugin.dobj.kollision.IUeberdeckungsFunktion;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

final class StandardUeberdeckungsFunktion
implements IUeberdeckungsFunktion {
    static final StandardUeberdeckungsFunktion INSTANZ = new StandardUeberdeckungsFunktion();

    StandardUeberdeckungsFunktion() {
    }

    @Override
    public double getUeberdeckungsKoeffizient(Point o1Ort, Object o1, Object o2) {
        IFigure f1 = (IFigure)Platform.getAdapterManager().getAdapter(o1, IFigure.class);
        IFigure f2 = (IFigure)Platform.getAdapterManager().getAdapter(o2, IFigure.class);
        if (f1 != null && f2 != null) {
            Rectangle b1 = f1.getBounds();
            Rectangle b2 = f2.getBounds();
            return StandardUeberdeckungsFunktion.getRectangleUeberdeckungsKoeffizient(o1Ort, b1, b2);
        }
        return 0.0;
    }

    public static double getRectangleUeberdeckungsKoeffizient(Point o1Ort, Rectangle b1Vorlaeufig, Rectangle b2) {
        Rectangle ueberdeckung;
        Rectangle b1 = b1Vorlaeufig;
        if (o1Ort != null) {
            int newWidth = b1Vorlaeufig.width;
            int newHeight = b1Vorlaeufig.height;
            b1 = new Rectangle(o1Ort.x - Math.round((float)newWidth / 2.0f), o1Ort.y - Math.round((float)newHeight / 2.0f), newWidth, newHeight);
        }
        if (b1 != null && b2 != null && !(ueberdeckung = b1.getIntersection(b2)).isEmpty()) {
            double b1A = b1.preciseWidth() * b1.preciseHeight();
            double b2A = b2.preciseWidth() * b2.preciseHeight();
            double ueberdeckungA = ueberdeckung.preciseWidth() * ueberdeckung.preciseHeight();
            return Math.max(ueberdeckungA / b1A, ueberdeckungA / b2A);
        }
        return 0.0;
    }
}

