/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SizedSection
extends AbstractSection<Sized> {
    private CLabel widthLabel;
    private Spinner widthSpinner;
    private CLabel heightLabel;
    private Spinner heightSpinner;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createLocation(container);
    }

    private void createLocation(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        final Button resetToDefaultButton = new Button(parent, 2);
        resetToDefaultButton.setToolTipText("Defaultwert f\u00fcr die Gr\u00f6\u00dfe verwenden.");
        Image image = DobjIcons.ActionRestoreDefault.getImageDescriptor().createImage();
        resetToDefaultButton.setImage(image);
        resetToDefaultButton.addDisposeListener(e -> image.dispose());
        FormData data = new FormData();
        data.width = resetToDefaultButton.computeSize((int)-1, (int)-1).x;
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        resetToDefaultButton.setLayoutData((Object)data);
        this.widthSpinner = new Spinner(parent, 2048);
        this.widthSpinner.setMinimum(1);
        this.widthSpinner.setMaximum(Integer.MAX_VALUE);
        this.widthSpinner.setIncrement(100);
        this.widthSpinner.setPageIncrement(1000);
        factory.adapt(parent);
        data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)resetToDefaultButton, 0, 0x1000000);
        this.widthSpinner.setLayoutData((Object)data);
        this.widthLabel = factory.createCLabel(parent, "Breite:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.widthSpinner, -5);
        data.top = new FormAttachment((Control)this.widthSpinner, 0, 0x1000000);
        this.widthLabel.setLayoutData((Object)data);
        this.heightSpinner = new Spinner(parent, 2048);
        this.heightSpinner.setMinimum(1);
        this.heightSpinner.setMaximum(Integer.MAX_VALUE);
        this.heightSpinner.setIncrement(100);
        this.heightSpinner.setPageIncrement(1000);
        factory.adapt(parent);
        data = new FormData();
        data.left = new FormAttachment((Control)this.widthSpinner, 170);
        data.right = new FormAttachment((Control)resetToDefaultButton);
        data.top = new FormAttachment((Control)this.widthSpinner, 0, 0x1000000);
        this.heightSpinner.setLayoutData((Object)data);
        this.heightLabel = factory.createCLabel(parent, "H\u00f6he:");
        data = new FormData();
        data.left = new FormAttachment(50, 5);
        data.right = new FormAttachment((Control)this.heightSpinner, -5);
        data.top = new FormAttachment((Control)this.heightSpinner, 0, 0x1000000);
        this.heightLabel.setLayoutData((Object)data);
        resetToDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = resetToDefaultButton.getSelection();
                Dimension value = useDefault ? null : new Dimension();
                SetCommand cmd = new SetCommand(SizedSection.this.getElement(), (EStructuralFeature)GefPackage.Literals.SIZED__SIZE, (Object)value);
                SizedSection.this.getCommandStack().execute((Command)cmd);
                SizedSection.this.setUseDefault(useDefault);
            }
        });
        SelectionAdapter sizeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EAttribute feature;
                Dimension size;
                if (e.widget == SizedSection.this.widthSpinner || e.widget == SizedSection.this.heightSpinner) {
                    size = ((Sized)SizedSection.this.getElement()).getSize();
                    if (size == null) {
                        size = new Dimension();
                    }
                    feature = GefPackage.Literals.SIZED__SIZE;
                    if (e.widget == SizedSection.this.widthSpinner) {
                        size.width = SizedSection.this.widthSpinner.getSelection();
                    } else {
                        size.height = SizedSection.this.heightSpinner.getSelection();
                    }
                } else {
                    return;
                }
                Dimension value = size;
                SetCommand cmd = new SetCommand(SizedSection.this.getElement(), (EStructuralFeature)feature, (Object)value);
                SizedSection.this.getCommandStack().execute((Command)cmd);
            }
        };
        this.widthSpinner.addSelectionListener((SelectionListener)sizeListener);
        this.heightSpinner.addSelectionListener((SelectionListener)sizeListener);
    }

    public void refresh() {
        int height;
        int width;
        Dimension size = ((Sized)this.getElement()).getSize();
        this.setUseDefault(size == null);
        if (size != null) {
            width = size.width;
            height = size.height;
        } else {
            width = 0;
            height = 0;
        }
        if (width != this.widthSpinner.getSelection()) {
            this.widthSpinner.setSelection(width);
        }
        if (height != this.heightSpinner.getSelection()) {
            this.heightSpinner.setSelection(height);
        }
    }

    private void setUseDefault(boolean useDefault) {
        this.widthLabel.setEnabled(!useDefault);
        this.widthSpinner.setEnabled(!useDefault);
        this.heightLabel.setEnabled(!useDefault);
        this.heightSpinner.setEnabled(!useDefault);
    }
}

