/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.tools.BaseTool;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;

public abstract class AbstractMarqueeSelectionTool
extends BaseTool {
    protected static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    protected static final int DEFAULT_MODE = 0;
    protected static final int TOGGLE_MODE = 1;
    protected static final int APPEND_MODE = 2;
    private int mode;
    private IFigure marqueeFeedbackFigure;
    private Set<EditPart> allChildren;
    private Collection<EditPart> selectedEditParts;
    private Request targetRequest;

    protected AbstractMarqueeSelectionTool() {
        this.setUnloadWhenFinished(false);
        this.setDefaultCursor(Cursors.CROSS);
    }

    protected int getSelectionMode() {
        return this.mode;
    }

    protected void setSelectionMode(int mode) {
        this.mode = mode;
    }

    protected boolean isTouchedSelection() {
        SelectionProperties property = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (property != null) {
            return property.isSelectTouched();
        }
        return false;
    }

    protected boolean isShowFeedback() {
        SelectionProperties property = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (property != null) {
            return property.isShowFeedback();
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    protected void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    protected void eraseMarqueeFeedback() {
        if (this.marqueeFeedbackFigure != null) {
            this.removeFeedback(this.marqueeFeedbackFigure);
            this.marqueeFeedbackFigure = null;
        }
    }

    protected void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        LinkedHashSet<EditPart> newSelections = new LinkedHashSet<EditPart>();
        HashSet<EditPart> deselections = new HashSet<EditPart>();
        this.calculateNewSelection(newSelections, deselections);
        if (this.getSelectionMode() != 0) {
            newSelections.addAll(viewer.getSelectedEditParts());
            newSelections.removeAll(deselections);
        }
        viewer.setSelection((ISelection)new StructuredSelection(newSelections.toArray()));
    }

    protected abstract void calculateNewSelection(Collection<EditPart> var1, Collection<EditPart> var2);

    protected Set<EditPart> getAllChildren() {
        if (this.allChildren == null) {
            this.allChildren = DobjUtil.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart());
        }
        return this.allChildren;
    }

    protected boolean isValidModel(Object object) {
        SelectionProperties selectionProperties = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (object instanceof DoModel) {
            DoModel model = (DoModel)object;
            if (selectionProperties == null) {
                return true;
            }
            return selectionProperties.getMatchDoTypen().contains(model.getDoTyp());
        }
        return false;
    }

    protected boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        IFigure walker = fig.getParent();
        while (!figBounds.isEmpty() && walker != null) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }

    protected IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeFeedbackFigure == null) {
            this.marqueeFeedbackFigure = this.createMarqueeFeedbackFigure();
            this.addFeedback(this.marqueeFeedbackFigure);
        }
        return this.marqueeFeedbackFigure;
    }

    protected abstract IFigure createMarqueeFeedbackFigure();

    protected abstract void showMarqueeFeedback();

    protected void showTargetFeedback() {
        for (EditPart editPart : this.selectedEditParts) {
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    protected Collection<EditPart> getSelectedEditParts() {
        return this.selectedEditParts;
    }

    protected void clearSelectedEditParts() {
        this.selectedEditParts = new ArrayList<EditPart>();
    }

    protected void clearAllChildren() {
        this.allChildren = null;
    }
}

