/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Cursors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class CrowdedEditPartsTracker
extends SelectEditPartTracker {
    private static final Comparator<EditPart> EDIT_PART_COMPARATOR = (o1, o2) -> {
        if (o1 != null && o2 != null && o1.getModel() != null && o2.getModel() != null) {
            if (o1.getModel() instanceof EObject && o2.getModel() instanceof EObject) {
                return EmfUtil.getText((EObject)((EObject)o1.getModel())).compareTo(EmfUtil.getText((EObject)((EObject)o2.getModel())));
            }
            return o1.getModel().toString().compareTo(o2.getModel().toString());
        }
        return 0;
    };
    private final Set<EditPart> moeglicheSelektionen;
    private EditPartViewer activationViewer;

    CrowdedEditPartsTracker(EditPart sourceEditPart, Set<EditPart> moeglicheSelektionen) {
        super(sourceEditPart);
        this.moeglicheSelektionen = moeglicheSelektionen;
        this.setDisabledCursor(Cursors.NO);
    }

    public void activate() {
        this.activationViewer = this.getCurrentViewer();
        if (this.activationViewer != null) {
            this.trySelektiereEinfachesObjekt((GraphicalViewer)this.activationViewer, this.moeglicheSelektionen);
        }
    }

    protected String getDebugName() {
        return "CrowdedEditPartsTracker: " + this.getCommandName();
    }

    private void trySelektiereEinfachesObjekt(GraphicalViewer viewer, Set<EditPart> editPartSet) {
        if (editPartSet == null || editPartSet.isEmpty()) {
            return;
        }
        Display display = viewer.getControl().getDisplay();
        Shell shell = new Shell(display);
        Menu menu = new Menu((Decorations)shell, 8);
        DOSelektionsListener listener = new DOSelektionsListener();
        List<EditPart> sortedEditPartList = Arrays.asList(editPartSet.toArray(new EditPart[0]));
        Collections.sort(sortedEditPartList, EDIT_PART_COMPARATOR);
        for (EditPart editPart : sortedEditPartList) {
            if (!editPart.isSelectable()) continue;
            MenuItem item = new MenuItem(menu, 32);
            item.setData((Object)editPart);
            if (editPart.getModel() instanceof DoModel) {
                DoModel doModel = (DoModel)editPart.getModel();
                item.setText(EmfUtil.getText((EObject)doModel) + "; " + EmfUtil.getText((EObject)doModel.getDoTyp()));
            } else {
                item.setText(editPart.getModel().toString());
            }
            item.setSelection(editPart.getSelected() != 0);
            item.addSelectionListener((SelectionListener)listener);
        }
        menu.setVisible(true);
    }

    private class DOSelektionsListener
    extends SelectionAdapter {
        private DOSelektionsListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem item;
            if (e.getSource() != null && e.getSource() instanceof MenuItem && (item = (MenuItem)e.getSource()).getData() != null && item.getData() instanceof EditPart) {
                EditPart gep = (EditPart)item.getData();
                CrowdedEditPartsTracker.this.activationViewer.select(gep);
            }
        }
    }
}

