/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.tools.CrowdedEditPartsTracker;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.PanningSelectionTool;

public class DObjSelectionTool
extends PanningSelectionTool {
    private Set<EditPart> allChildren;

    protected boolean handleButtonDown(int button) {
        EditPart editpart = this.getTargetEditPart();
        if (button == 1 && editpart != null) {
            if (this.isValidModel(editpart.getModel())) {
                Set<EditPart> moeglicheObjekteInAusschnitt = this.getCrowdedEditPartsNear(editpart);
                if (moeglicheObjekteInAusschnitt.size() > 1) {
                    CrowdedEditPartsTracker tracker = new CrowdedEditPartsTracker(editpart, moeglicheObjekteInAusschnitt);
                    tracker.setViewer(this.getCurrentViewer());
                    this.setDragTracker((DragTracker)tracker);
                    this.lockTargetEditPart(editpart);
                    return true;
                }
            } else {
                if (editpart.getModel() == null || !(editpart.getModel() instanceof DoModel)) {
                    return super.handleButtonDown(button);
                }
                if (button == 1 && this.getCurrentViewer().getControl() instanceof FigureCanvas && this.stateTransition(128, 256)) {
                    return super.handleButtonDown(button);
                }
                return true;
            }
        }
        return super.handleButtonDown(button);
    }

    private Set<EditPart> getCrowdedEditPartsNear(EditPart sourceEditPart) {
        ZoomManager zm;
        HashSet<EditPart> crowdedEditParts = new HashSet<EditPart>();
        if (this.getCurrentViewer() != null && this.getCurrentViewer() instanceof GraphicalViewer && this.getCurrentViewer().getRootEditPart() != null && (zm = (ZoomManager)this.getCurrentViewer().getProperty(ZoomManager.class.toString())) != null) {
            Point drawPoint = this.getLocation();
            RootEditPart root = this.getCurrentViewer().getRootEditPart();
            if (root instanceof ScalableRootEditPart) {
                ScalableRootEditPart scalableRoot = (ScalableRootEditPart)root;
                drawPoint = new Point(drawPoint.x + scalableRoot.getFigure().getClientArea().x, drawPoint.y + scalableRoot.getFigure().getClientArea().y);
            }
            drawPoint.performScale(1.0 / zm.getZoom());
            Set<EditPart> moeglicheObjekteInAusschnitt = this.getAllChildren();
            for (EditPart e : moeglicheObjekteInAusschnitt) {
                GraphicalEditPart target = (GraphicalEditPart)e;
                if (target instanceof RootEditPart || !target.getFigure().isShowing() || !this.isValidModel(target.getModel()) || !target.getFigure().containsPoint(drawPoint) || !target.isSelectable()) continue;
                crowdedEditParts.add((EditPart)target);
            }
        }
        return crowdedEditParts;
    }

    protected boolean isValidModel(Object object) {
        SelectionProperties selectionProperties = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (object instanceof DoModel) {
            if (selectionProperties == null) {
                return true;
            }
            DoModel model = (DoModel)object;
            return selectionProperties.getMatchDoTypen().contains(model.getDoTyp());
        }
        return false;
    }

    protected Set<EditPart> getAllChildren() {
        if (this.allChildren == null) {
            this.allChildren = DobjUtil.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart());
        }
        return this.allChildren;
    }

    public void resetChildren() {
        this.allChildren = null;
    }
}

