/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.figures.EllipseFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.tools.RectangleSelectionTool;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public class EllipseSelectionTool
extends RectangleSelectionTool {
    @Override
    protected String getCommandName() {
        return "Rechteckselektion";
    }

    @Override
    protected void calculateNewSelection(Collection<EditPart> newSelections, Collection<EditPart> deselections) {
        Rectangle marqueeRect = this.getMarqueeSelectionRectangle();
        for (GraphicalEditPart graphicalEditPart : this.getAllChildren()) {
            if (!this.isValidModel(graphicalEditPart.getModel())) continue;
            IFigure figure = graphicalEditPart.getFigure();
            if (!graphicalEditPart.isSelectable() || graphicalEditPart.getTargetEditPart(MARQUEE_REQUEST) != graphicalEditPart || !this.isFigureVisible(figure) || !figure.isShowing()) continue;
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            Ellipse2D.Double marqueeEllipse = new Ellipse2D.Double();
            ((RectangularShape)marqueeEllipse).setFrame(marqueeRect.x, marqueeRect.y, marqueeRect.width, marqueeRect.height);
            if (this.isTouchedSelection()) {
                if (!marqueeEllipse.contains(r.x, r.y, r.width, r.height) && !marqueeEllipse.intersects(r.x, r.y, r.width, r.height)) continue;
                if (graphicalEditPart.getSelected() == 0 || this.getSelectionMode() != 1) {
                    newSelections.add((EditPart)graphicalEditPart);
                    continue;
                }
                deselections.add((EditPart)graphicalEditPart);
                continue;
            }
            if (!marqueeEllipse.contains(r.x, r.y, r.width, r.height)) continue;
            if (graphicalEditPart.getSelected() == 0 || this.getSelectionMode() != 1) {
                newSelections.add((EditPart)graphicalEditPart);
                continue;
            }
            deselections.add((EditPart)graphicalEditPart);
        }
    }

    @Override
    protected IFigure createMarqueeFeedbackFigure() {
        return new EllipseFeedbackFigure();
    }
}

