/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.tools.BaseTool;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;
import de.bsvrz.buv.plugin.dobj.vektor.LinAlgUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;

public class PolygonSelectionTool
extends BaseTool
implements ZoomListener {
    private static final double CLOSE_DISTANCE = 5.0;
    private PolygonToolState currentState;
    private Polyline marqueePolygon;
    private final Set<GraphicalEditPart> selectedEditParts = new HashSet<GraphicalEditPart>();

    public PolygonSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
        this.setSelectionState(PolygonToolState.NoSelection);
    }

    protected String getCommandName() {
        return "Polygonselektion";
    }

    public void zoomChanged(double zoom) {
        this.handleInvalidInput();
    }

    protected boolean handleButtonUp(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        if (PolygonToolState.NoSelection.equals((Object)this.currentState)) {
            this.setSelectionState(PolygonToolState.SelectionInProgress);
            this.getZoomManager().addZoomListener((ZoomListener)this);
            this.marqueePolygon.addPoint(this.getDrawPoint(this.getLocation()));
            GraphicalViewer viewer = (GraphicalViewer)this.getCurrentViewer();
            this.selectedEditParts.clear();
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1) || this.getCurrentInput().isShiftKeyDown()) {
                for (Object e : viewer.getEditPartRegistry().values()) {
                    GraphicalEditPart editPart = (GraphicalEditPart)e;
                    if (editPart.getSelected() == 0) continue;
                    this.selectedEditParts.add(editPart);
                }
            } else {
                this.getCurrentViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.setSelected(this.selectedEditParts);
        } else if (PolygonToolState.SelectionInProgress.equals((Object)this.currentState)) {
            if (this.marqueePolygon.getPoints().size() > 2 && this.getDrawPoint(this.getLocation()).getDistance(this.marqueePolygon.getPoints().getFirstPoint()) < 5.0 && PolygonToolState.SelectionInProgress.equals((Object)this.currentState)) {
                this.marqueePolygon.addPoint(this.marqueePolygon.getStart());
                this.setSelectionState(PolygonToolState.SelectionFinished);
                this.getZoomManager().removeZoomListener((ZoomListener)this);
                return true;
            }
            if (!this.isMarqueePolygonValid()) {
                this.handleInvalidInput();
            } else {
                this.marqueePolygon.addPoint(this.getDrawPoint(this.getLocation()));
            }
        } else {
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleMove() {
        if (PolygonToolState.SelectionInProgress.equals((Object)this.currentState)) {
            if (this.marqueePolygon.getPoints().size() > 1) {
                this.marqueePolygon.setPoint(this.getDrawPoint(this.getLocation()), this.marqueePolygon.getPoints().size() - 1);
            } else {
                this.marqueePolygon.addPoint(this.getDrawPoint(this.getLocation()));
            }
            if (this.marqueePolygon.getPoints().size() > 2) {
                double dist = this.marqueePolygon.getPoints().getFirstPoint().getDistance(this.marqueePolygon.getPoints().getLastPoint());
                if (dist < 5.0) {
                    this.setCursor(Cursors.HAND);
                } else {
                    this.setCursor(Cursors.CROSS);
                }
            }
        }
        return super.handleMove();
    }

    private Point getDrawPoint(Point viewPoint) {
        RootEditPart root = this.getCurrentViewer().getRootEditPart();
        if (root instanceof ScalableRootEditPart) {
            ScalableRootEditPart scalableRoot = (ScalableRootEditPart)root;
            return new Point(viewPoint.x + scalableRoot.getFigure().getClientArea().x, viewPoint.y + scalableRoot.getFigure().getClientArea().y);
        }
        throw new IllegalStateException("Root nicht gefunden");
    }

    private boolean isMarqueePolygonValid() {
        if (this.marqueePolygon.getPoints().size() > 3) {
            Point p1 = this.marqueePolygon.getPoints().getPoint(this.marqueePolygon.getPoints().size() - 2);
            Point p2 = this.marqueePolygon.getPoints().getPoint(this.marqueePolygon.getPoints().size() - 1);
            int i = 1;
            while (i < this.marqueePolygon.getPoints().size() - 2) {
                Point p22;
                Point p12 = this.marqueePolygon.getPoints().getPoint(i - 1);
                Point pSchnitt = LinAlgUtil.getSchnittpunkt(p1, p2, p12, p22 = this.marqueePolygon.getPoints().getPoint(i));
                if (pSchnitt != null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void setSelected(Collection<GraphicalEditPart> editPartSet) {
        if (editPartSet != null) {
            for (GraphicalEditPart editPart : editPartSet) {
                editPart.setSelected(1);
            }
            this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartSet.toArray()));
        }
    }

    protected boolean handleInvalidInput() {
        this.setSelectionState(PolygonToolState.NoSelection);
        this.eraseFeedback();
        return true;
    }

    private void setSelectionState(PolygonToolState state) {
        this.currentState = state;
        switch (state) {
            case NoSelection: {
                if (this.marqueePolygon != null && this.getCurrentViewer() != null && this.getCurrentViewer().getEditPartRegistry() != null) {
                    this.removeFeedback((IFigure)this.marqueePolygon);
                }
                this.marqueePolygon = null;
                break;
            }
            case SelectionInProgress: {
                this.showFeedback();
                break;
            }
            case SelectionFinished: {
                this.calculateNewSelection(this.selectedEditParts);
                this.setSelectionState(PolygonToolState.NoSelection);
                this.setSelected(this.selectedEditParts);
                this.setCursor(Cursors.CROSS);
            }
        }
    }

    protected void calculateNewSelection(Collection<GraphicalEditPart> newSelections) {
        LocationRequest hoverRequest = new LocationRequest();
        hoverRequest.setType((Object)"selection hover");
        ZoomManager zm = this.getZoomManager();
        PointList pl = this.marqueePolygon.getPoints().getCopy();
        pl.performScale(1.0 / zm.getZoom());
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentViewer();
        for (Object e : viewer.getEditPartRegistry().values()) {
            GraphicalEditPart editPart = (GraphicalEditPart)e;
            if (!editPart.getFigure().isShowing() || !this.isValidModel(editPart.getModel()) || !LinAlgUtil.polygonContainsRectangle(pl, editPart.getFigure(), this.isTouchedSelection())) continue;
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                if (newSelections.contains(editPart)) {
                    newSelections.remove(editPart);
                    continue;
                }
                newSelections.add(editPart);
                continue;
            }
            newSelections.add(editPart);
        }
    }

    protected boolean isValidModel(Object object) {
        SelectionProperties selectionProperties = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (object instanceof DoModel) {
            if (selectionProperties == null) {
                return true;
            }
            DoModel model = (DoModel)object;
            return selectionProperties.getMatchDoTypen().contains(model.getDoTyp());
        }
        return false;
    }

    protected boolean isTouchedSelection() {
        SelectionProperties property = (SelectionProperties)this.getCurrentViewer().getProperty(SelectionProperties.class.toString());
        if (property != null) {
            return property.isSelectTouched();
        }
        return false;
    }

    protected void showFeedback() {
        this.marqueePolygon = new Polyline();
        this.marqueePolygon.setForegroundColor(ColorConstants.white);
        this.marqueePolygon.setBackgroundColor(ColorConstants.black);
        this.marqueePolygon.setXOR(true);
        this.marqueePolygon.setLineStyle(2);
        this.marqueePolygon.setLineWidth(1);
        this.addFeedback((IFigure)this.marqueePolygon);
    }

    protected void eraseFeedback() {
        if (this.marqueePolygon != null) {
            this.removeFeedback((IFigure)this.marqueePolygon);
            this.marqueePolygon = null;
        }
    }

    private static enum PolygonToolState {
        NoSelection,
        SelectionInProgress,
        SelectionFinished;

    }
}

