/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.figures.RectangleFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.tools.AbstractMarqueeSelectionTool;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.SWT;

public class RectangleSelectionTool
extends AbstractMarqueeSelectionTool {
    protected String getCommandName() {
        return "Rechteckselektion";
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.clearAllChildren();
        this.setState(0x40000000);
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.clearSelectedEditParts();
            this.calculateNewSelection(this.getSelectedEditParts(), new ArrayList<EditPart>());
            this.showTargetFeedback();
            if (this.isShowFeedback()) {
                this.performMarqueeSelect();
            }
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    @Override
    protected void calculateNewSelection(Collection<EditPart> newSelections, Collection<EditPart> deselections) {
        Rectangle marqueeRect = this.getMarqueeSelectionRectangle();
        for (GraphicalEditPart graphicalEditPart : this.getAllChildren()) {
            if (!this.isValidModel(graphicalEditPart.getModel())) continue;
            IFigure figure = graphicalEditPart.getFigure();
            if (!graphicalEditPart.isSelectable() || graphicalEditPart.getTargetEditPart(MARQUEE_REQUEST) != graphicalEditPart || !this.isFigureVisible(figure) || !figure.isShowing()) continue;
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            if (this.isTouchedSelection()) {
                if (!marqueeRect.contains(r) && !marqueeRect.intersects(r)) continue;
                if (graphicalEditPart.getSelected() == 0 || this.getSelectionMode() != 1) {
                    newSelections.add((EditPart)graphicalEditPart);
                    continue;
                }
                deselections.add((EditPart)graphicalEditPart);
                continue;
            }
            if (!marqueeRect.contains(r)) continue;
            if (graphicalEditPart.getSelected() == 0 || this.getSelectionMode() != 1) {
                newSelections.add((EditPart)graphicalEditPart);
                continue;
            }
            deselections.add((EditPart)graphicalEditPart);
        }
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    @Override
    protected void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    @Override
    protected IFigure createMarqueeFeedbackFigure() {
        return new RectangleFeedbackFigure();
    }
}

