/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import com.bitctrl.graph.Bogen;
import com.bitctrl.graph.Graph;
import com.bitctrl.graph.GraphAlgorithm;
import com.bitctrl.graph.Knoten;
import com.bitctrl.util.CollectionUtilities;
import de.bsvrz.buv.plugin.dobj.figures.LineFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.graph.NetzBogen;
import de.bsvrz.buv.plugin.dobj.graph.NetzGraph;
import de.bsvrz.buv.plugin.dobj.graph.NetzKnoten;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.tools.AbstractDragTool;
import de.bsvrz.buv.plugin.dobj.tools.IStreckenSelektierbar;
import de.bsvrz.buv.plugin.selektion.SelektionsTransfer;
import de.bsvrz.buv.rw.bitctrl.CacheService;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.attribute.AttTmcRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdAeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Netz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.NetzCacheExtended;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StreckeSelectionTool
extends AbstractDragTool {
    private static final EditPartViewer.Conditional CONDITIONAL_STRASSENKNOTEN = editpart -> {
        SystemObject obj = (SystemObject)Platform.getAdapterManager().getAdapter((Object)editpart, SystemObject.class);
        if (obj != null) {
            return obj.isOfType("typ.stra\u00dfenKnoten");
        }
        return false;
    };
    private LineFeedbackFigure feedbackFigure;
    private NetzGraph graph;
    private NetzKnoten startKnoten;
    private NetzKnoten zielKnoten;
    private boolean initialized;
    private final CacheService cacheService = RahmenwerkService.getService().getCacheService();
    private final PropertyChangeListener cacheListener = evt -> {
        boolean bl = this.initialized = this.cacheService.getNetzCacheExtended(this.cacheService.getDefaultNetzPid()).isInitialisiert();
    };

    public StreckeSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "Streckenselektion";
    }

    public void activate() {
        NetzCacheExtended nce = this.cacheService.getNetzCacheExtended(this.cacheService.getDefaultNetzPid());
        this.initialized = nce.isInitialisiert();
        nce.addPropertyChangeListener(this.cacheListener);
        super.activate();
        this.graph = new NetzGraph((Netz)nce.getNetz());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        NetzCacheExtended nce = this.cacheService.getNetzCacheExtended(this.cacheService.getDefaultNetzPid());
        nce.removePropertyChangeListener(this.cacheListener);
    }

    protected boolean handleMove() {
        if (this.getStrassenknoten(this.getLocation()) != null) {
            this.setCursor(Cursors.CROSS);
        } else {
            this.setCursor(SharedCursors.CURSOR_PLUG_NOT);
        }
        return true;
    }

    private EditPart getStrassenknoten(Point location) {
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentViewer();
        EditPart editPart = viewer.findObjectAtExcluding(location, Collections.emptyList(), CONDITIONAL_STRASSENKNOTEN);
        SystemObject so = (SystemObject)Platform.getAdapterManager().getAdapter((Object)editPart, SystemObject.class);
        if (so != null && so.isOfType("typ.stra\u00dfenKnoten")) {
            return editPart;
        }
        return null;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (!this.initialized) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Streckenselektion ist noch nicht initialisiert.", (String)"Bitte Warten. Das Streckenselektionswerkzeug kann erst verwendet werden, wenn der erweiterte Netz-Cache geladen ist.");
            return false;
        }
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1 || this.getStrassenknoten(this.getLocation()) == null) {
            this.setState(8);
            this.handleInvalidInput();
        } else {
            this.initDrag();
        }
        this.stateTransition(1, 4);
        return true;
    }

    @Override
    protected boolean handleInvalidInput() {
        this.graph = null;
        this.startKnoten = null;
        this.zielKnoten = null;
        return super.handleInvalidInput();
    }

    private void initDrag() {
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentViewer();
        EditPart startEditPart = viewer.findObjectAtExcluding(this.getStartLocation(), Collections.emptySet(), CONDITIONAL_STRASSENKNOTEN);
        this.startKnoten = this.graph.getKnoten((StrassenKnoten)((BitCtrlDoModel)startEditPart.getModel()).getSystemObjekt());
        GraphAlgorithm.breitensuche((Graph)this.graph, (Knoten)this.startKnoten);
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.startKnoten == null) {
            this.setCursor(SharedCursors.CURSOR_PLUG_NOT);
            return super.handleDragInProgress();
        }
        EditPart zielEditPart = this.getStrassenknoten(this.getLocation());
        if (zielEditPart == null) {
            this.setCursor(SharedCursors.CURSOR_PLUG_NOT);
            return super.handleDragInProgress();
        }
        this.zielKnoten = this.graph.getKnoten((StrassenKnoten)((BitCtrlDoModel)zielEditPart.getModel()).getSystemObjekt());
        Set<String> intersection = this.getStrassenIdsVonStartNachZielKnoten();
        if (intersection.isEmpty()) {
            this.setCursor(SharedCursors.CURSOR_PLUG_NOT);
        } else {
            this.setCursor(Cursors.CROSS);
        }
        return super.handleDragInProgress();
    }

    protected void handleFinished() {
        if (this.startKnoten == null || this.zielKnoten == null) {
            super.handleFinished();
            return;
        }
        Set<String> strassen = this.getStrassenIdsVonStartNachZielKnoten();
        if (strassen.isEmpty()) {
            super.handleFinished();
            return;
        }
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentViewer();
        ArrayList<Object> systemObjekte = new ArrayList<Object>();
        List bogenListe = GraphAlgorithm.getPfadVonWurzel((Knoten)this.zielKnoten);
        if (bogenListe != null) {
            ArrayList<StrassenKnoten> knotenList = new ArrayList<StrassenKnoten>();
            knotenList.add(this.startKnoten.getStrassenKnoten());
            int i = 0;
            while (i < bogenListe.size()) {
                NetzBogen netzBogen = (NetzBogen)bogenListe.get(i);
                AeusseresStrassenSegment nachStrassenSegment = netzBogen.getAeusseresStrassenSegment();
                if (i > 0) {
                    NetzBogen lastBogen = (NetzBogen)bogenListe.get(i - 1);
                    AeusseresStrassenSegment vonStrassenSegment = lastBogen.getAeusseresStrassenSegment();
                    NetzKnoten knoten = (NetzKnoten)netzBogen.getAnfangsKnoten();
                    knotenList.add(knoten.getStrassenKnoten());
                    InneresStrassenSegment iss = knoten.getInneresStrassenSegment(vonStrassenSegment, nachStrassenSegment);
                    systemObjekte.add(iss);
                }
                systemObjekte.add(nachStrassenSegment);
                ++i;
            }
            knotenList.add(this.zielKnoten.getStrassenKnoten());
            String strassenIdTarget = null;
            if (!strassen.isEmpty()) {
                strassenIdTarget = strassen.iterator().next();
            }
            if (knotenList.size() > 1) {
                NetzCacheExtended netzCacheExtended = this.cacheService.getNetzCacheExtended(this.cacheService.getDefaultNetzPid());
                HashMap knotenToAssListMap = new HashMap();
                int k = 0;
                while (k < knotenList.size() - 1) {
                    StrassenKnoten sk1 = (StrassenKnoten)knotenList.get(k);
                    StrassenKnoten sk2 = (StrassenKnoten)knotenList.get(k + 1);
                    List segmenteAusKnoten = netzCacheExtended.getAeussereStrassenSegmente(sk1);
                    ArrayList<AeusseresStrassenSegment> assList = new ArrayList<AeusseresStrassenSegment>();
                    for (AeusseresStrassenSegment ass : segmenteAusKnoten) {
                        StrassenKnoten nach = ((KdAeusseresStrassenSegment.Daten)ass.getKdAeusseresStrassenSegment().getDatum()).getNachKnoten();
                        if (!nach.equals(sk2)) continue;
                        assList.add(ass);
                    }
                    knotenToAssListMap.put(sk1, assList);
                    ++k;
                }
                ArrayList<Object> objekteDummy = new ArrayList<Object>();
                if (strassenIdTarget != null) {
                    int k2 = 0;
                    while (k2 < knotenList.size() - 1) {
                        StrassenKnoten sk1 = (StrassenKnoten)knotenList.get(k2);
                        StrassenKnoten sk2 = (StrassenKnoten)knotenList.get(k2 + 1);
                        ArrayList<AeusseresStrassenSegment> assTargetList = new ArrayList<AeusseresStrassenSegment>();
                        for (AeusseresStrassenSegment ass : (List)knotenToAssListMap.get(sk1)) {
                            String strassenId = StreckeSelectionTool.getStrassenId((StrassenSegment)ass);
                            if (strassenId == null || !strassenId.equals(strassenIdTarget)) continue;
                            assTargetList.add(ass);
                        }
                        if (!assTargetList.isEmpty()) {
                            AttTmcRichtung assRichtung = null;
                            InneresStrassenSegment issTarget = null;
                            boolean assTargetSet = false;
                            for (AeusseresStrassenSegment assTarget : assTargetList) {
                                if (assTarget.getKdAeusseresStrassenSegment() != null && assTarget.getKdAeusseresStrassenSegment().getDatum() != null && ((KdAeusseresStrassenSegment.Daten)assTarget.getKdAeusseresStrassenSegment().getDatum()).getTmcRichtung() != null) {
                                    assRichtung = ((KdAeusseresStrassenSegment.Daten)assTarget.getKdAeusseresStrassenSegment().getDatum()).getTmcRichtung();
                                }
                                if (!assTargetSet) {
                                    objekteDummy.add(assTarget);
                                    assTargetSet = true;
                                }
                                if (k2 >= knotenList.size() - 2) continue;
                                for (InneresStrassenSegment iss : netzCacheExtended.getInneresStrassenSegmente(sk2, assTarget)) {
                                    String issStrassenId = StreckeSelectionTool.getStrassenId((StrassenSegment)iss);
                                    AttTmcRichtung issRichtung = netzCacheExtended.getRichtung(iss);
                                    if (assRichtung != null && issRichtung != null) {
                                        if (issStrassenId == null || !issStrassenId.equals(strassenIdTarget) || !assRichtung.equals((Object)issRichtung)) continue;
                                        issTarget = iss;
                                        break;
                                    }
                                    if (issStrassenId == null || !issStrassenId.equals(strassenIdTarget)) continue;
                                    issTarget = iss;
                                    break;
                                }
                                if (issTarget != null) break;
                            }
                            if (issTarget != null) {
                                objekteDummy.add(issTarget);
                            }
                        }
                        ++k2;
                    }
                }
                systemObjekte.clear();
                systemObjekte.addAll(objekteDummy);
            }
        }
        Map editPartRegistry = viewer.getEditPartRegistry();
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (SystemObjekt systemObjekt : systemObjekte) {
            for (Map.Entry e : editPartRegistry.entrySet()) {
                if (!(e.getKey() instanceof DoModel)) continue;
                DoModel model = (DoModel)e.getKey();
                EditPart editPart = (EditPart)e.getValue();
                if (!(editPart instanceof IStreckenSelektierbar) || !(model instanceof BitCtrlDoModel) || !systemObjekt.equals(((BitCtrlDoModel)model).getSystemObjekt()) || !editPart.isSelectable()) continue;
                editParts.add(editPart);
            }
        }
        viewer.setSelection((ISelection)new StructuredSelection(editParts));
        if (editParts.size() > 0) {
            viewer.reveal((EditPart)editParts.get(editParts.size() - 1));
        }
        SelektionsTransfer.getInstanz().setDefinierteSelektion("SELECTION:STRECKEN_ZUG", true, (IStructuredSelection)new StructuredSelection(systemObjekte));
        super.handleFinished();
    }

    private Set<String> getStrassenIdsVonStartNachZielKnoten() {
        Set<String> strassenIds = new HashSet<String>();
        if (this.startKnoten != null && this.zielKnoten != null) {
            HashSet<String> strassen1 = new HashSet<String>();
            for (Bogen b : this.startKnoten.ausgangsBogenIterator()) {
                NetzBogen nb = (NetzBogen)b;
                AeusseresStrassenSegment ass = nb.getAeusseresStrassenSegment();
                String strassenId = StreckeSelectionTool.getStrassenId((StrassenSegment)ass);
                if (strassenId == null) continue;
                strassen1.add(strassenId);
            }
            HashSet<String> strassen2 = new HashSet<String>();
            for (Bogen b : this.zielKnoten.ausgangsBogenIterator()) {
                NetzBogen nb = (NetzBogen)b;
                AeusseresStrassenSegment ass = nb.getAeusseresStrassenSegment();
                String strassenId = StreckeSelectionTool.getStrassenId((StrassenSegment)ass);
                if (strassenId == null) continue;
                strassen2.add(strassenId);
            }
            strassenIds = CollectionUtilities.intersection(strassen1, strassen2);
        }
        return strassenIds;
    }

    private static String getStrassenId(StrassenSegment ass) {
        Strasse strasse;
        KdStrassenSegment.Daten datumStrassenSegment;
        Object strassenId = null;
        if (ass.getKdStrassenSegment() != null && (datumStrassenSegment = (KdStrassenSegment.Daten)ass.getKdStrassenSegment().getDatum()) != null && datumStrassenSegment.getGehoertZuStrasse() != null && (strasse = datumStrassenSegment.getGehoertZuStrasse()).getKdStrasse() != null && strasse.getKdStrasse().getDatum() != null) {
            strassenId = ((KdStrasse.Daten)strasse.getKdStrasse().getDatum()).getTyp().toString() + " " + String.valueOf(((KdStrasse.Daten)strasse.getKdStrasse().getDatum()).getNummer()) + " " + ((KdStrasse.Daten)strasse.getKdStrasse().getDatum()).getZusatz();
            strassenId = ((String)strassenId).trim();
        }
        return strassenId;
    }

    private LineFeedbackFigure getFeedbackFigure() {
        if (this.feedbackFigure == null) {
            this.feedbackFigure = new LineFeedbackFigure();
            this.addFeedback((IFigure)this.feedbackFigure);
        }
        return this.feedbackFigure;
    }

    @Override
    protected void showFeedback() {
        Point start = this.getStartLocation();
        Point end = this.getLocation();
        Rectangle rect = new Rectangle(start, end);
        this.getFeedbackFigure().translateToRelative((Translatable)rect);
        this.getFeedbackFigure().translateToRelative((Translatable)start);
        this.getFeedbackFigure().translateToRelative((Translatable)end);
        this.getFeedbackFigure().setStart(start);
        this.getFeedbackFigure().setEnd(end);
        this.getFeedbackFigure().setBounds(rect);
    }

    @Override
    protected void eraseFeedback() {
        if (this.feedbackFigure != null) {
            this.removeFeedback((IFigure)this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }
}

