/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.util;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.util.BildEvent;
import de.bsvrz.buv.plugin.dobj.util.BildListener;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.InvalidationListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.Datensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.konfigurationsdaten.KdBild;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword;
import de.bsvrz.sys.funclib.dynobj.DynObjektException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public final class BildManager
implements DavVerbindungsListener {
    public static final BildManager INSTANCE = new BildManager();
    private final EventListenerList listener = new EventListenerList();
    private final InternalListener internalListener = new InternalListener();
    private boolean registered;
    private final Map<Bild, ImageData> bilder = new HashMap<Bild, ImageData>();

    private BildManager() {
        RahmenwerkService.getService().getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this);
    }

    public synchronized void addBilderListener(BildListener l) {
        this.listener.add(BildListener.class, l);
        this.registerDavListener();
    }

    private void registerDavListener() {
        ClientDavInterface dav;
        if (!this.registered && this.listener.getListenerCount(BildListener.class) == 1 && (dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung()) != null) {
            DynamicObjectType type = (DynamicObjectType)dav.getDataModel().getType("typ.bild");
            type.addObjectCreationListener((DynamicObjectType.DynamicObjectCreatedListener)this.internalListener);
            type.addInvalidationListener((InvalidationListener)this.internalListener);
            type.addNameChangeListener((DynamicObjectType.NameChangeListener)this.internalListener);
            this.registered = true;
        }
    }

    public synchronized void removeBilderListener(BildListener l) {
        this.listener.remove(BildListener.class, l);
        this.removeDavListener(false);
    }

    private void removeDavListener(boolean forced) {
        if (this.registered) {
            if (this.listener.getListenerCount(BildListener.class) == 0) {
                ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
                if (dav != null) {
                    DynamicObjectType type = (DynamicObjectType)dav.getDataModel().getType("typ.bild");
                    type.removeObjectCreationListener((DynamicObjectType.DynamicObjectCreatedListener)this.internalListener);
                    type.removeInvalidationListener((InvalidationListener)this.internalListener);
                    type.removeNameChangeListener((DynamicObjectType.NameChangeListener)this.internalListener);
                }
                this.registered = false;
            }
            if (forced) {
                this.registered = false;
            }
        }
    }

    protected synchronized void fireBildAngelegt(Bild bild) {
        BildEvent e = new BildEvent(this, bild);
        BildListener[] bildListenerArray = (BildListener[])this.listener.getListeners(BildListener.class);
        int n = bildListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BildListener l = bildListenerArray[n2];
            l.bildAngelegt(e);
            ++n2;
        }
    }

    protected synchronized void fireBildEntfernt(Bild bild) {
        BildEvent e = new BildEvent(this, bild);
        this.bilder.remove(bild);
        BildListener[] bildListenerArray = (BildListener[])this.listener.getListeners(BildListener.class);
        int n = bildListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BildListener l = bildListenerArray[n2];
            l.bildEntfernt(e);
            ++n2;
        }
    }

    protected synchronized void fireBildUmbenannt(Bild bild) {
        BildEvent e = new BildEvent(this, bild);
        BildListener[] bildListenerArray = (BildListener[])this.listener.getListeners(BildListener.class);
        int n = bildListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BildListener l = bildListenerArray[n2];
            l.bildUmbenannt(e);
            ++n2;
        }
    }

    protected synchronized void fireBildConnection() {
        BildEvent e = new BildEvent(this, null);
        BildListener[] bildListenerArray = (BildListener[])this.listener.getListeners(BildListener.class);
        int n = bildListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BildListener l = bildListenerArray[n2];
            l.bildConnection(e);
            ++n2;
        }
    }

    public Collection<Bild> getBilder() {
        ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
        if (objektFactory.isVerbunden()) {
            for (SystemObjekt so : objektFactory.bestimmeModellobjekte(new String[]{"typ.bild"})) {
                if (this.bilder.containsKey(so)) continue;
                this.bilder.put((Bild)so, null);
            }
        }
        return this.bilder.keySet();
    }

    public void anlegenBild(String name, String pid, String mimeType, byte[] buffer) throws DynObjektException {
        ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
        KdBild.Daten daten = new KdBild.Daten((Datensatz)new KdBild(null, objektFactory), KdBild.Aspekte.Eigenschaften);
        daten.setMIMEType(mimeType);
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            daten.getBilddaten().add((Object)new AttByte_JavaKeyword(Byte.valueOf(element)));
            ++n2;
        }
        objektFactory.createDynamischesObjekt(Bild.class, name, pid, new KonfigurationsDatum[]{daten});
    }

    public void entfernenBild(Bild bild) throws DynObjektException {
        RahmenwerkService.getService().getObjektFactory().invalidateDynamischesObjekt((DynamischesObjekt)bild);
    }

    public ImageDescriptor getImageDescriptor(Bild bild) {
        return this.getLimitedImageDescriptor(bild, 0, 0);
    }

    public ImageDescriptor getLimitedImageDescriptor(Bild bild, int maxWidth, int maxHeight) {
        ImageData data = this.bilder.get(bild);
        if (data == null) {
            Feld bilddaten = ((KdBild.Daten)bild.getKdBild().getDatum()).getBilddaten();
            byte[] buffer = new byte[bilddaten.size()];
            int i = 0;
            while (i < bilddaten.size()) {
                buffer[i] = ((AttByte_JavaKeyword)bilddaten.get(i)).byteValue();
                ++i;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            data = new ImageData((InputStream)in);
            if (this.bilder.containsKey(bild)) {
                this.bilder.put(bild, data);
            }
        }
        double scale = 1.0;
        if (maxWidth > 0 && maxWidth < data.width) {
            scale = (double)maxWidth / (double)data.width;
        }
        if (maxHeight > 0 && maxHeight < data.height) {
            scale = Math.min(scale, (double)maxHeight / (double)data.height);
        }
        if (scale < 1.0) {
            data = data.scaledTo((int)((double)data.width * scale), (int)((double)data.height * scale));
        }
        return ImageDescriptor.createFromImageData((ImageData)data);
    }

    public void verbindungHergestellt(DavVerbindungsEvent event) {
        this.registerDavListener();
        this.fireBildConnection();
    }

    public void verbindungGetrennt(DavVerbindungsEvent event) {
        this.removeDavListener(true);
        this.fireBildConnection();
    }

    public boolean verbindungHalten(DavVerbindungsEvent event) {
        return false;
    }

    private class InternalListener
    implements DynamicObjectType.DynamicObjectCreatedListener,
    InvalidationListener,
    DynamicObjectType.NameChangeListener {
        private InternalListener() {
        }

        public void invalidObject(DynamicObject so) {
            BildManager.this.fireBildEntfernt((Bild)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }

        public void objectCreated(DynamicObject so) {
            BildManager.this.fireBildAngelegt((Bild)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }

        public void nameChanged(DynamicObject so) {
            BildManager.this.fireBildUmbenannt((Bild)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }
    }
}

