/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.util;

import com.bitctrl.resource.PortableBitmap;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.util.PortableBitMapEvent;
import de.bsvrz.buv.plugin.dobj.util.PortableBitMapListener;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.InvalidationListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.Datensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlPortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.konfigurationsdaten.KdPortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv;
import de.bsvrz.sys.funclib.dynobj.DynObjektException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.event.EventListenerList;

public final class PortableBitMapManager
implements DavVerbindungsListener {
    public static final PortableBitMapManager INSTANCE = new PortableBitMapManager();
    private final EventListenerList listener = new EventListenerList();
    private final InternalListener internalListener = new InternalListener();
    private boolean registered;

    private PortableBitMapManager() {
        RahmenwerkService.getService().getRahmenWerk().addDavVerbindungsListener((DavVerbindungsListener)this);
    }

    public synchronized void addPortableBitMapListener(PortableBitMapListener l) {
        this.listener.add(PortableBitMapListener.class, l);
        this.registerDavListener();
    }

    private void registerDavListener() {
        ClientDavInterface dav;
        if (!this.registered && this.listener.getListenerCount(PortableBitMapListener.class) == 1 && (dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung()) != null) {
            DynamicObjectType type = (DynamicObjectType)dav.getDataModel().getType("typ.portableBitMap");
            type.addObjectCreationListener((DynamicObjectType.DynamicObjectCreatedListener)this.internalListener);
            type.addInvalidationListener((InvalidationListener)this.internalListener);
            type.addNameChangeListener((DynamicObjectType.NameChangeListener)this.internalListener);
            this.registered = true;
        }
    }

    public synchronized void removePortableBitMapListener(PortableBitMapListener l) {
        this.listener.remove(PortableBitMapListener.class, l);
        this.removeDavListener(false);
    }

    private void removeDavListener(boolean force) {
        if (this.registered) {
            if (this.listener.getListenerCount(PortableBitMapListener.class) == 0) {
                ClientDavInterface dav = RahmenwerkService.getService().getRahmenWerk().getDavVerbindung();
                if (dav != null) {
                    DynamicObjectType type = (DynamicObjectType)dav.getDataModel().getType("typ.portableBitMap");
                    type.removeObjectCreationListener((DynamicObjectType.DynamicObjectCreatedListener)this.internalListener);
                    type.removeInvalidationListener((InvalidationListener)this.internalListener);
                    type.removeNameChangeListener((DynamicObjectType.NameChangeListener)this.internalListener);
                }
                this.registered = false;
            }
            if (force) {
                this.registered = false;
            }
        }
    }

    protected synchronized void firePortableBitMapConnection() {
        PortableBitMapEvent e = new PortableBitMapEvent(this, null);
        PortableBitMapListener[] portableBitMapListenerArray = (PortableBitMapListener[])this.listener.getListeners(PortableBitMapListener.class);
        int n = portableBitMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortableBitMapListener l = portableBitMapListenerArray[n2];
            l.portableBitMapConnection(e);
            ++n2;
        }
    }

    protected synchronized void firePortableBitMapAngelegt(PortableBitMap portableBitMap) {
        PortableBitMapEvent e = new PortableBitMapEvent(this, portableBitMap);
        PortableBitMapListener[] portableBitMapListenerArray = (PortableBitMapListener[])this.listener.getListeners(PortableBitMapListener.class);
        int n = portableBitMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortableBitMapListener l = portableBitMapListenerArray[n2];
            l.portableBitMapAngelegt(e);
            ++n2;
        }
    }

    protected synchronized void firePortableBitMapEntfernt(PortableBitMap portableBitMap) {
        PortableBitMapEvent e = new PortableBitMapEvent(this, portableBitMap);
        PortableBitMapListener[] portableBitMapListenerArray = (PortableBitMapListener[])this.listener.getListeners(PortableBitMapListener.class);
        int n = portableBitMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortableBitMapListener l = portableBitMapListenerArray[n2];
            l.portableBitMapEntfernt(e);
            ++n2;
        }
    }

    protected synchronized void firePortableBitMapUmbenannt(PortableBitMap portableBitMap) {
        PortableBitMapEvent e = new PortableBitMapEvent(this, portableBitMap);
        PortableBitMapListener[] portableBitMapListenerArray = (PortableBitMapListener[])this.listener.getListeners(PortableBitMapListener.class);
        int n = portableBitMapListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortableBitMapListener l = portableBitMapListenerArray[n2];
            l.portableBitMapUmbenannt(e);
            ++n2;
        }
    }

    public Collection<PortableBitMap> getPortableBitMaps() {
        HashSet<PortableBitMap> bitmaps = new HashSet<PortableBitMap>();
        ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
        if (objektFactory.isVerbunden()) {
            for (SystemObjekt so : objektFactory.bestimmeModellobjekte(new String[]{"typ.portableBitMap"})) {
                bitmaps.add((PortableBitMap)so);
            }
        }
        return bitmaps;
    }

    public void anlegenPortableBitMap(String name, String pid, PortableBitmap bitmap) throws DynObjektException {
        ObjektFactory objektFactory = RahmenwerkService.getService().getObjektFactory();
        KdPortableBitMap.Daten daten = this.konvertieren(bitmap);
        objektFactory.createDynamischesObjekt(PortableBitMap.class, name, pid, new KonfigurationsDatum[]{daten});
    }

    private KdPortableBitMap.Daten konvertieren(PortableBitmap bitmap) {
        KdPortableBitMap.Daten daten = new KdPortableBitMap.Daten((Datensatz)new KdPortableBitMap(null, RahmenwerkService.getService().getObjektFactory()), KdPortableBitMap.Aspekte.Eigenschaften);
        AtlPortableBitMap bildDaten = new AtlPortableBitMap();
        bildDaten.getAusmasse().setBreite(new AttZahlPositiv(Long.valueOf(bitmap.getWidth())));
        bildDaten.getAusmasse().setHoehe(new AttZahlPositiv(Long.valueOf(bitmap.getHeight())));
        int maxLen = 70;
        StringBuilder buffer = new StringBuilder();
        int zeile = 0;
        while (zeile < bitmap.getHeight()) {
            int spalte = 0;
            while (spalte < bitmap.getWidth()) {
                if (buffer.length() >= 70 || buffer.length() >= bitmap.getWidth()) {
                    bildDaten.getMaske().add((Object)buffer.toString());
                    buffer.setLength(0);
                }
                if (bitmap.getPixel(spalte, zeile) == 0) {
                    buffer.append('0');
                } else {
                    buffer.append('1');
                }
                ++spalte;
            }
            ++zeile;
        }
        if (buffer.length() > 0) {
            bildDaten.getMaske().add((Object)buffer.toString());
        }
        daten.setBilddaten(bildDaten);
        return daten;
    }

    public void entfernenPortableBitMap(PortableBitMap portableBitMap) throws DynObjektException {
        RahmenwerkService.getService().getObjektFactory().invalidateDynamischesObjekt((DynamischesObjekt)portableBitMap);
    }

    public void aktualisierenPortableBitMap(PortableBitMap bitmap, PortableBitmap bildDaten) throws ConfigurationChangeException {
        KdPortableBitMap.Daten daten = this.konvertieren(bildDaten);
        bitmap.getKdPortableBitMap().setDatum((KonfigurationsDatum)daten);
    }

    public void verbindungHergestellt(DavVerbindungsEvent event) {
        this.registerDavListener();
        this.firePortableBitMapConnection();
    }

    public void verbindungGetrennt(DavVerbindungsEvent event) {
        this.removeDavListener(true);
        this.firePortableBitMapConnection();
    }

    public boolean verbindungHalten(DavVerbindungsEvent event) {
        return false;
    }

    private class InternalListener
    implements DynamicObjectType.DynamicObjectCreatedListener,
    InvalidationListener,
    DynamicObjectType.NameChangeListener {
        private InternalListener() {
        }

        public void invalidObject(DynamicObject so) {
            PortableBitMapManager.this.firePortableBitMapEntfernt((PortableBitMap)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }

        public void objectCreated(DynamicObject so) {
            PortableBitMapManager.this.firePortableBitMapAngelegt((PortableBitMap)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }

        public void nameChanged(DynamicObject so) {
            PortableBitMapManager.this.firePortableBitMapUmbenannt((PortableBitMap)RahmenwerkService.getService().getObjektFactory().getModellobjekt((SystemObject)so));
        }
    }
}

