/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import de.bsvrz.buv.plugin.dobj.vektor.LineareFunktion;
import de.bsvrz.buv.plugin.dobj.vektor.PKStack;
import de.bsvrz.buv.plugin.dobj.vektor.ParallelKomplex;
import de.bsvrz.buv.plugin.dobj.vektor.Vektor2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;

public final class LinAlgUtil {
    private LinAlgUtil() {
    }

    private static boolean isRedundant(ParallelKomplex pkfMinus1, ParallelKomplex pkf, ParallelKomplex pkfPlus1) {
        Point pVor = pkf.calcSchnittPunktMitVorgaenger(pkfMinus1);
        Point pNach = pkf.calcSchnittPunktMitNachfolger(pkfPlus1);
        Vektor2D vStrich = new Vektor2D(pVor, pNach);
        double winkel = LinAlgUtil.getWinkel(pkf.getV(), vStrich);
        return winkel > Math.PI;
    }

    public static PointList verschiebeUndStrecke(PointList originalPunkte, int abstand, double scale) {
        return LinAlgUtil.verschiebe(originalPunkte, abstand);
    }

    public static PointList verschiebe(PointList originalPunkte, int abstand) {
        if (abstand == 0) {
            return originalPunkte;
        }
        List<LineareFunktion> funktionen = LinAlgUtil.getLineareFunktionenParallelZumPolygon(originalPunkte, abstand);
        if (funktionen.isEmpty()) {
            return new PointList();
        }
        PointList bildPunkte = new PointList();
        bildPunkte.addPoint(funktionen.get(0).getStartPunkt());
        int i = 0;
        while (i < funktionen.size()) {
            LineareFunktion fi = funktionen.get(i);
            if (i < funktionen.size() - 1) {
                LineareFunktion fiPlus1 = funktionen.get(i + 1);
                try {
                    Point schnittPunkt = LinAlgUtil.getSchnittpunkt(fi, fiPlus1);
                    if (schnittPunkt == null) {
                        return new PointList();
                    }
                    if (schnittPunkt.getDistance(fi.getEndPunkt()) > (double)abstand) {
                        schnittPunkt = fi.getEndPunkt();
                    }
                    bildPunkte.addPoint(schnittPunkt);
                }
                catch (IllegalArgumentException ex) {
                    return new PointList();
                }
            } else {
                bildPunkte.addPoint(fi.getEndPunkt());
            }
            ++i;
        }
        return bildPunkte;
    }

    public static PointList verschiebeNeu(PointList originalPunkte, int abstand) {
        PointList verschiedenePunkte = LinAlgUtil.getVerschiedenePunkte(originalPunkte);
        if (verschiedenePunkte.size() <= 1) {
            return originalPunkte;
        }
        PKStack stack = new PKStack();
        ArrayList<ParallelKomplex> komplexe = new ArrayList<ParallelKomplex>();
        int i = 0;
        while (i < verschiedenePunkte.size() - 1) {
            Point p1 = verschiedenePunkte.getPoint(i);
            Point p2 = verschiedenePunkte.getPoint(i + 1);
            komplexe.add(new ParallelKomplex(p1, p2, abstand));
            ++i;
        }
        i = 0;
        while (i < komplexe.size()) {
            ParallelKomplex pkfPlus1;
            ParallelKomplex pkf;
            ParallelKomplex pkfMinus1 = stack.popGet();
            boolean redundant = LinAlgUtil.isRedundant(pkfMinus1, pkf = (ParallelKomplex)komplexe.get(i), pkfPlus1 = i + 1 == komplexe.size() ? null : (ParallelKomplex)komplexe.get(i + 1));
            if (!redundant) {
                stack.push(pkf);
            }
            ++i;
        }
        return stack.getPunkte();
    }

    public static double getWinkel(Vektor2D a, Vektor2D b) {
        double d = a.getLaenge() * b.getLaenge();
        if (d == 0.0) {
            return 0.0;
        }
        return Math.acos((a.x * b.x + a.y * b.y) / d);
    }

    public static List<LineareFunktion> getLineareFunktionenParallelZumPolygon(PointList punkte, double abstand) {
        PointList verschiedenePunkte = LinAlgUtil.getVerschiedenePunkte(punkte);
        ArrayList<LineareFunktion> funktionen = new ArrayList<LineareFunktion>();
        if (verschiedenePunkte.size() > 1) {
            boolean rechtenNormalenVektor = abstand > 0.0;
            double derAbstand = Math.abs(abstand);
            int i = 0;
            while (i < verschiedenePunkte.size() - 1) {
                Point a = verschiedenePunkte.getPoint(i);
                Point b = verschiedenePunkte.getPoint(i + 1);
                Vektor2D vab = new Vektor2D(a, b);
                Vektor2D normalenVektorNormiert = rechtenNormalenVektor ? vab.getNormalenVektorRechts().getVektorNormiert() : vab.getNormalenVektorLinks().getVektorNormiert();
                funktionen.add(new LineareFunktion((Point)new PrecisionPoint((double)a.x + derAbstand * normalenVektorNormiert.x, (double)a.y + derAbstand * normalenVektorNormiert.y), (Point)new PrecisionPoint((double)b.x + derAbstand * normalenVektorNormiert.x, (double)b.y + derAbstand * normalenVektorNormiert.y)));
                ++i;
            }
        }
        return funktionen;
    }

    private static PointList getVerschiedenePunkte(PointList punkte) {
        if (punkte.size() == 0) {
            return new PointList();
        }
        PointList verschiedenePunkte = new PointList();
        verschiedenePunkte.addPoint(punkte.getFirstPoint());
        if (punkte.size() > 1) {
            int i = 1;
            while (i < punkte.size()) {
                Point naechsterPunkt = punkte.getPoint(i);
                if (!naechsterPunkt.equals((Object)verschiedenePunkte.getLastPoint())) {
                    verschiedenePunkte.addPoint(naechsterPunkt);
                }
                ++i;
            }
        }
        return verschiedenePunkte;
    }

    public static PointList strecke(PointList punkte, double mindestAbstand) {
        if (punkte == null) {
            return new PointList();
        }
        if (punkte.size() > 2) {
            PointList abbildung = new PointList();
            PointList streckListe = new PointList();
            abbildung.addPoint(punkte.getFirstPoint());
            int i = 0;
            while (i < punkte.size() - 1) {
                Point p2;
                Point p1 = punkte.getPoint(i);
                Vektor2D v = new Vektor2D(p1, p2 = punkte.getPoint(i + 1));
                if (v.getLaenge() < mindestAbstand) {
                    streckListe.addPoint(p2);
                } else {
                    if (streckListe.size() > 1) {
                        abbildung.addPoint(LinAlgUtil.getSchwerpunkt(streckListe));
                    }
                    abbildung.addPoint(p2);
                    streckListe = new PointList();
                }
                ++i;
            }
            if (streckListe.size() > 1) {
                streckListe.removePoint(streckListe.size() - 1);
                abbildung.addPoint(LinAlgUtil.getSchwerpunkt(streckListe));
            }
            abbildung.addPoint(punkte.getLastPoint());
            return abbildung;
        }
        return punkte;
    }

    private static Point getSchwerpunkt(PointList punktMenge) {
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < punktMenge.size()) {
            Point p = punktMenge.getPoint(i);
            x += p.preciseX();
            y += p.preciseY();
            ++i;
        }
        return new PrecisionPoint(x / (double)punktMenge.size(), y / (double)punktMenge.size());
    }

    public static Point getPunktNebenPunktListeAnfang(PointList punkte, double abstand) {
        Vektor2D normalenVektor2d = LinAlgUtil.getNormalenVektorZumErstenLinienZugVon(punkte, abstand >= 0.0);
        if (normalenVektor2d != null) {
            Point p1 = punkte.getFirstPoint();
            double absAbstand = Math.abs(abstand);
            return new PrecisionPoint((double)p1.x + normalenVektor2d.getVektorNormiert().x * absAbstand, (double)p1.y + normalenVektor2d.getVektorNormiert().y * absAbstand);
        }
        return null;
    }

    public static Vektor2D getNormalenVektorZumErstenLinienZugVon(PointList punkte, boolean rechts) {
        if (punkte.size() > 1) {
            Point p1 = punkte.getFirstPoint();
            Point p2 = punkte.getPoint(1);
            int i = 2;
            while (p1.equals((Object)p2) && i < punkte.size()) {
                p2 = punkte.getPoint(i);
                ++i;
            }
            if (!p1.equals((Object)p2)) {
                Vektor2D v = new Vektor2D(p1, p2);
                if (rechts) {
                    return v.getNormalenVektorRechts();
                }
                return v.getNormalenVektorLinks();
            }
        }
        return null;
    }

    public static Point getSchnittpunkt(LineareFunktion f1, LineareFunktion f2) {
        double xSchnittPunkt = 0.0;
        double ySchnittPunkt = 0.0;
        if (f1.isYParallele() || f2.isYParallele()) {
            if (f1.isYParallele() && f2.isYParallele()) {
                if (f1.getStartPunkt().x == f2.getStartPunkt().x) {
                    return f1.getEndPunkt();
                }
                return null;
            }
            if (f1.isYParallele()) {
                xSchnittPunkt = f1.getStartPunkt().x;
                ySchnittPunkt = f2.getFunktionsWert(xSchnittPunkt);
            } else {
                xSchnittPunkt = f2.getStartPunkt().x;
                ySchnittPunkt = f1.getFunktionsWert(xSchnittPunkt);
            }
        } else {
            double m1MinusM2 = f1.getAnstieg() - f2.getAnstieg();
            if (m1MinusM2 == 0.0) {
                if (f1.getAbsolutglied() != f2.getAbsolutglied()) {
                    return null;
                }
                return f1.getEndPunkt();
            }
            xSchnittPunkt = (f2.getAbsolutglied() - f1.getAbsolutglied()) / m1MinusM2;
            ySchnittPunkt = f1.getAnstieg() * xSchnittPunkt + f1.getAbsolutglied();
        }
        return new PrecisionPoint(xSchnittPunkt, ySchnittPunkt);
    }

    public static Point getSchnittpunkt(Point s1p1, Point s1p2, Point s2p1, Point s2p2) {
        LineareFunktion f1 = new LineareFunktion(s1p1, s1p2);
        LineareFunktion f2 = new LineareFunktion(s2p1, s2p2);
        Point schnittPunkt = LinAlgUtil.getSchnittpunkt(f1, f2);
        if (schnittPunkt != null) {
            Rectangle rs1 = new Rectangle(s1p1, s1p2);
            Rectangle rs2 = new Rectangle(s2p1, s2p2);
            if (rs1.contains(schnittPunkt) && rs2.contains(schnittPunkt)) {
                return schnittPunkt;
            }
        }
        return null;
    }

    public static boolean polygonContainsRectangle(PointList polygon, IFigure figure, boolean intersectionModeOn) {
        int boundsIncluded = 0;
        Point[] shapeDescriptor = LinAlgUtil.getShapeDescriptor(figure);
        if (polygon.size() > 3) {
            Point[] pointArray = shapeDescriptor;
            int n = shapeDescriptor.length;
            int n2 = 0;
            while (n2 < n) {
                Point boundsPoint = pointArray[n2];
                Point s1p1 = new Point(0, boundsPoint.y);
                Point s1p2 = new Point(boundsPoint.x, boundsPoint.y);
                int intersectionCount = 0;
                if (!s1p1.equals((Object)s1p2)) {
                    int i = 1;
                    while (i < polygon.size()) {
                        Point schnittPunkt = LinAlgUtil.getSchnittpunkt(s1p1, s1p2, polygon.getPoint(i - 1), polygon.getPoint(i));
                        if (schnittPunkt != null) {
                            ++intersectionCount;
                        }
                        ++i;
                    }
                }
                if (intersectionModeOn && (boundsIncluded += intersectionCount & 1) > 0) {
                    boundsIncluded = shapeDescriptor.length;
                    break;
                }
                ++n2;
            }
        }
        return boundsIncluded == shapeDescriptor.length;
    }

    private static Point[] getShapeDescriptor(IFigure figure) {
        if (figure instanceof Ellipse) {
            return new Point[]{new Point((figure.getBounds().getTopLeft().x + figure.getBounds().getTopRight().x) / 2, figure.getBounds().getTopLeft().y), new Point((figure.getBounds().getBottomLeft().x + figure.getBounds().getBottomRight().x) / 2, figure.getBounds().getBottomLeft().y), new Point(figure.getBounds().getTopLeft().x, (figure.getBounds().getTopLeft().y + figure.getBounds().getBottomLeft().y) / 2), new Point(figure.getBounds().getTopRight().x, (figure.getBounds().getTopRight().y + figure.getBounds().getBottomRight().y) / 2)};
        }
        return new Point[]{figure.getBounds().getTopLeft(), figure.getBounds().getBottomLeft(), figure.getBounds().getBottomRight(), figure.getBounds().getTopRight()};
    }

    public static Set<EditPart> getAllChildrenOf(EditPart editPart) {
        HashSet<EditPart> allChildren = new HashSet<EditPart>();
        if (editPart != null) {
            LinAlgUtil.getAllChildren(editPart, allChildren);
        }
        return allChildren;
    }

    private static void getAllChildren(EditPart editPart, Set<EditPart> allChildren) {
        List children = editPart.getChildren();
        for (Object child2 : children) {
            EditPart child = (EditPart)child2;
            allChildren.add(child);
            LinAlgUtil.getAllChildren(child, allChildren);
        }
    }
}

