/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import de.bsvrz.buv.plugin.dobj.vektor.LinAlgUtil;
import de.bsvrz.buv.plugin.dobj.vektor.LineareFunktion;
import de.bsvrz.buv.plugin.dobj.vektor.Vektor2D;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

class ParallelKomplex {
    private final LineareFunktion f;
    private final Point p1;
    private final Point p2;
    private final Point p1Strich;
    private final Point p2Strich;
    private final Vektor2D v;
    private Point pSchnittMitVorgaenger;
    private Point pSchnittMitNachfolger;

    ParallelKomplex(Point p1, Point p2, double a) {
        double aAbsolut = Math.abs(a);
        this.p1 = p1;
        this.p2 = p2;
        this.v = new Vektor2D(p1, p2);
        boolean rechtenNormalenVektor = a > 0.0;
        Vektor2D normalenVektorNormiert = rechtenNormalenVektor ? this.v.getNormalenVektorRechts().getVektorNormiert() : this.v.getNormalenVektorLinks().getVektorNormiert();
        this.p1Strich = new PrecisionPoint((double)p1.x + aAbsolut * normalenVektorNormiert.x, (double)p1.y + aAbsolut * normalenVektorNormiert.y);
        this.p2Strich = new PrecisionPoint((double)p2.x + aAbsolut * normalenVektorNormiert.x, (double)p2.y + aAbsolut * normalenVektorNormiert.y);
        this.f = new LineareFunktion(this.p1Strich, this.p2Strich);
    }

    final Point calcSchnittPunktMitVorgaenger(ParallelKomplex vorgaenger) {
        this.pSchnittMitVorgaenger = vorgaenger == null ? this.p1Strich : LinAlgUtil.getSchnittpunkt(vorgaenger.getF(), this.f);
        return this.pSchnittMitVorgaenger;
    }

    final Point calcSchnittPunktMitNachfolger(ParallelKomplex nachfolger) {
        this.pSchnittMitNachfolger = nachfolger == null ? this.p2Strich : LinAlgUtil.getSchnittpunkt(this.f, nachfolger.getF());
        return this.pSchnittMitNachfolger;
    }

    final Point getpSchnittMitVorgaenger() {
        return this.pSchnittMitVorgaenger;
    }

    final Point getpSchnittMitNachfolger() {
        return this.pSchnittMitNachfolger;
    }

    final LineareFunktion getF() {
        return this.f;
    }

    final Point getP1() {
        return this.p1;
    }

    final Point getP2() {
        return this.p2;
    }

    final Point getP1Strich() {
        return this.p1Strich;
    }

    final Point getP2Strich() {
        return this.p2Strich;
    }

    final Vektor2D getV() {
        return this.v;
    }
}

