/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class DoGraphics
extends ScaledGraphics {
    public static final double MAX_TEXT_SIZE = 0.45;
    private static int[][] intArrayCache = new int[8][];
    private final Rectangle tempRECT = new Rectangle();
    private boolean allowText = true;
    private final Map<FontKey, Font> fontCache = new HashMap<FontKey, Font>();
    private final Map<Font, FontData> fontDataCache = new HashMap<Font, FontData>();
    private double fractionalX;
    private double fractionalY;
    private final Graphics graphics;
    private final FontHeightCache localCache = new FontHeightCache();
    private Font localFont;
    private int localLineWidth;
    private final Stack<State> stack = new Stack();
    private final FontHeightCache targetCache = new FontHeightCache();
    private double xZoom = 1.0;
    private double yZoom = 1.0;

    static {
        int i = 0;
        while (i < intArrayCache.length) {
            DoGraphics.intArrayCache[i] = new int[i + 1];
            ++i;
        }
    }

    public DoGraphics(Graphics g) {
        super(g);
        this.graphics = g;
        this.localFont = g.getFont();
        this.localLineWidth = g.getLineWidth();
    }

    public void clipRect(Rectangle r) {
        this.graphics.clipRect(this.zoomClipRect(r));
    }

    private Font createFont(FontData data) {
        return new Font((Device)Display.getCurrent(), data);
    }

    public void dispose() {
        this.stack.clear();
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.drawArc(z, offset, sweep);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.graphics.drawFocus(this.zoomRect(x, y, w, h));
    }

    public void drawImage(Image srcImage, int x, int y) {
        org.eclipse.swt.graphics.Rectangle size = srcImage.getBounds();
        double imageZoom = Math.min(this.xZoom, this.yZoom);
        this.graphics.drawImage(srcImage, 0, 0, size.width, size.height, (int)Math.floor((double)x * this.xZoom + this.fractionalX), (int)Math.floor((double)y * this.yZoom + this.fractionalY), (int)Math.floor((double)size.width * imageZoom + this.fractionalX), (int)Math.floor((double)size.height * imageZoom + this.fractionalY));
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        Rectangle t = this.zoomRect(tx, ty, tw, th);
        if (!t.isEmpty()) {
            this.graphics.drawImage(srcImage, sx, sy, sw, sh, t.x, t.y, t.width, t.height);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine((int)Math.floor((double)x1 * this.xZoom + this.fractionalX), (int)Math.floor((double)y1 * this.yZoom + this.fractionalY), (int)Math.floor((double)x2 * this.xZoom + this.fractionalX), (int)Math.floor((double)y2 * this.yZoom + this.fractionalY));
    }

    public void drawOval(int x, int y, int w, int h) {
        this.graphics.drawOval(this.zoomRect(x, y, w, h));
    }

    public void drawPoint(int x, int y) {
        this.graphics.drawPoint((int)Math.floor((double)x * this.xZoom + this.fractionalX), (int)Math.floor((double)y * this.yZoom + this.fractionalY));
    }

    public void drawPolygon(int[] points) {
        this.graphics.drawPolygon(this.zoomPointList(points));
    }

    public void drawPolygon(PointList points) {
        this.graphics.drawPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void drawPolyline(int[] points) {
        this.graphics.drawPolyline(this.zoomPointList(points));
    }

    public void drawPolyline(PointList points) {
        this.graphics.drawPolyline(this.zoomPointList(points.toIntArray()));
    }

    public void drawRectangle(int x, int y, int w, int h) {
        this.graphics.drawRectangle(this.zoomRect(x, y, w, h));
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRectangle(this.zoomRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.xZoom), (int)((double)arcHeight * this.yZoom));
    }

    public void drawString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawString(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y, int style) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y), style);
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        TextLayout scaled = this.zoomTextLayout(layout);
        if (scaled != null) {
            this.graphics.drawTextLayout(scaled, (int)Math.floor((double)x * this.xZoom + this.fractionalX), (int)Math.floor((double)y * this.yZoom + this.fractionalY), selectionStart, selectionEnd, selectionBackground, selectionForeground);
            scaled.dispose();
        }
    }

    public void fillArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomFillRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.fillArc(z, offset, sweep);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(this.zoomFillRect(x, y, w, h), vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.graphics.fillOval(this.zoomFillRect(x, y, w, h));
    }

    public void fillPolygon(int[] points) {
        this.graphics.fillPolygon(this.zoomPointList(points));
    }

    public void fillPolygon(PointList points) {
        this.graphics.fillPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void fillRectangle(int x, int y, int w, int h) {
        this.graphics.fillRectangle(this.zoomFillRect(x, y, w, h));
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRectangle(this.zoomFillRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.xZoom), (int)((double)arcHeight * this.yZoom));
    }

    public void fillString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillString(s, this.zoomTextPoint(x, y));
        }
    }

    public void fillText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillText(s, this.zoomTextPoint(x, y));
        }
    }

    public double getAbsoluteScale() {
        return this.xZoom * this.graphics.getAbsoluteScale();
    }

    public int getAlpha() {
        return this.graphics.getAlpha();
    }

    public int getAntialias() {
        return this.graphics.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    Font getCachedFont(FontKey key) {
        Font font = this.fontCache.get(key);
        if (font != null) {
            return font;
        }
        FontData data = key.font.getFontData()[0];
        data.setHeight(key.height);
        Font zoomedFont = this.createFont(data);
        this.fontCache.put(key, zoomedFont);
        return zoomedFont;
    }

    private FontData getCachedFontData(Font f) {
        FontData data = this.fontDataCache.get(f);
        if (data != null) {
            return data;
        }
        data = this.getLocalFont().getFontData()[0];
        this.fontDataCache.put(f, data);
        return data;
    }

    public Rectangle getClip(Rectangle rect) {
        this.graphics.getClip(rect);
        int x = (int)((double)rect.x / this.xZoom);
        int y = (int)((double)rect.y / this.yZoom);
        rect.width = (int)Math.ceil((double)rect.right() / this.xZoom) - x;
        rect.height = (int)Math.ceil((double)rect.bottom() / this.yZoom) - y;
        rect.x = x;
        rect.y = y;
        return rect;
    }

    public int getFillRule() {
        return this.graphics.getFillRule();
    }

    public Font getFont() {
        return this.getLocalFont();
    }

    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics((Font)this.localFont);
    }

    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    public int getInterpolation() {
        return this.graphics.getInterpolation();
    }

    public int getLineCap() {
        return this.graphics.getLineCap();
    }

    public int getLineJoin() {
        return this.graphics.getLineJoin();
    }

    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.getLocalLineWidth();
    }

    private Font getLocalFont() {
        return this.localFont;
    }

    private int getLocalLineWidth() {
        return this.localLineWidth;
    }

    public int getTextAntialias() {
        return this.graphics.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    public void popState() {
        this.graphics.popState();
        State state = this.stack.pop();
        this.restoreLocalState(state);
    }

    public void pushState() {
        this.stack.push(new State(this.xZoom, this.yZoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.localLineWidth));
        this.graphics.pushState();
    }

    private void restoreLocalState(State state) {
        this.fractionalX = state.appliedX;
        this.fractionalY = state.appliedY;
        this.setScale((float)state.xZoom, (float)state.yZoom);
        this.setLocalFont(state.font);
        this.setLocalLineWidth(state.lineWidth);
    }

    public void restoreState() {
        this.graphics.restoreState();
        this.restoreLocalState(this.stack.peek());
    }

    public void scale(float xAmount, float yAmount) {
        this.setScale((float)(this.xZoom * (double)xAmount), (float)(this.yZoom * (double)yAmount));
    }

    public void scale(double amount) {
        throw new UnsupportedOperationException("Operation not supported, use scale(x, y)");
    }

    public void setAlpha(int alpha) {
        this.graphics.setAlpha(alpha);
    }

    public void setAntialias(int value) {
        this.graphics.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.graphics.setBackgroundColor(rgb);
    }

    public void setClip(Rectangle r) {
        this.graphics.setClip(this.zoomClipRect(r));
    }

    public void setFillRule(int rule) {
        this.graphics.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.setLocalFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.graphics.setForegroundColor(rgb);
    }

    public void setInterpolation(int interpolation) {
        this.graphics.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.graphics.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.graphics.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.graphics.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.graphics.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.setLocalLineWidth(width);
    }

    private void setLocalFont(Font f) {
        this.localFont = f;
        this.graphics.setFont(this.zoomFont(f));
    }

    private void setLocalLineWidth(int width) {
        this.localLineWidth = width;
        this.graphics.setLineWidth(this.zoomLineWidth(width));
    }

    public void setScale(float xValue, float yValue) {
        if ((double)xValue == this.xZoom && (double)yValue == this.yZoom) {
            return;
        }
        this.xZoom = xValue;
        this.yZoom = yValue;
        this.graphics.setFont(this.zoomFont(this.getLocalFont()));
        this.graphics.setLineWidth(this.zoomLineWidth(this.localLineWidth));
    }

    void setScale(double value) {
        this.setScale((float)value, (float)value);
    }

    public void setTextAntialias(int value) {
        this.graphics.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.graphics.setXORMode(b);
    }

    public void translate(int dx, int dy) {
        double dxFloat = (double)dx * this.xZoom + this.fractionalX;
        double dyFloat = (double)dy * this.yZoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    private Rectangle zoomClipRect(Rectangle r) {
        this.tempRECT.x = (int)Math.floor((double)r.x * this.xZoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)r.y * this.yZoom + this.fractionalY);
        this.tempRECT.width = (int)Math.ceil((double)(r.x + r.width) * this.xZoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.ceil((double)(r.y + r.height) * this.yZoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private Rectangle zoomFillRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.xZoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.yZoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w - 1) * this.xZoom + this.fractionalX) - this.tempRECT.x + 1;
        this.tempRECT.height = (int)Math.floor((double)(y + h - 1) * this.yZoom + this.fractionalY) - this.tempRECT.y + 1;
        return this.tempRECT;
    }

    private Font zoomFont(Font fnt) {
        FontData data;
        int zoomedFontHeight;
        Font calcFont = fnt;
        if (calcFont == null) {
            calcFont = Display.getCurrent().getSystemFont();
        }
        this.allowText = (zoomedFontHeight = this.zoomFontHeight((data = this.getCachedFontData(calcFont)).getHeight())) > 0;
        return this.getCachedFont(new FontKey(calcFont, zoomedFontHeight));
    }

    private int zoomFontHeight(int height) {
        double tmp = Math.min(this.yZoom, this.xZoom);
        if (tmp < 0.45) {
            return (int)(tmp * (double)height);
        }
        return (int)((double)height * tmp);
    }

    private int zoomLineWidth(int w) {
        return w;
    }

    private int[] zoomPointList(int[] points) {
        int[] scaled = null;
        int i = 0;
        while (i < intArrayCache.length) {
            if (intArrayCache[i].length == points.length) {
                scaled = intArrayCache[i];
                if (i != 0) {
                    int[] temp = intArrayCache[i - 1];
                    DoGraphics.intArrayCache[i - 1] = scaled;
                    DoGraphics.intArrayCache[i] = temp;
                }
            }
            ++i;
        }
        if (scaled == null) {
            DoGraphics.intArrayCache[DoGraphics.intArrayCache.length - 1] = new int[points.length];
            scaled = intArrayCache[intArrayCache.length - 1];
        }
        i = 0;
        while (i + 1 < points.length) {
            scaled[i] = (int)Math.floor((double)points[i] * this.xZoom + this.fractionalX);
            scaled[i + 1] = (int)Math.floor((double)points[i + 1] * this.yZoom + this.fractionalY);
            i += 2;
        }
        return scaled;
    }

    private Rectangle zoomRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.xZoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.yZoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w) * this.xZoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.floor((double)(y + h) * this.yZoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private TextLayout zoomTextLayout(TextLayout layout) {
        TextLayout zoomed = new TextLayout((Device)Display.getCurrent());
        zoomed.setText(layout.getText());
        int zoomWidth = -1;
        if (layout.getWidth() != -1) {
            zoomWidth = (int)((double)layout.getWidth() * this.xZoom);
        }
        if (zoomWidth < -1 || zoomWidth == 0) {
            return null;
        }
        zoomed.setFont(this.zoomFont(layout.getFont()));
        zoomed.setAlignment(layout.getAlignment());
        zoomed.setAscent(layout.getAscent());
        zoomed.setDescent(layout.getDescent());
        zoomed.setOrientation(layout.getOrientation());
        zoomed.setSegments(layout.getSegments());
        zoomed.setSpacing(layout.getSpacing());
        zoomed.setTabs(layout.getTabs());
        zoomed.setWidth(zoomWidth);
        int length = layout.getText().length();
        if (length > 0) {
            int start = 0;
            int offset = 1;
            TextStyle style = null;
            TextStyle lastStyle = layout.getStyle(0);
            while (offset <= length) {
                style = layout.getStyle(offset);
                if (offset == length || style != lastStyle) {
                    int end = offset - 1;
                    if (lastStyle != null) {
                        TextStyle zoomedStyle = new TextStyle(this.zoomFont(lastStyle.font), lastStyle.foreground, lastStyle.background);
                        zoomed.setStyle(zoomedStyle, start, end);
                    }
                    lastStyle = style;
                    start = offset;
                }
                ++offset;
            }
        }
        return zoomed;
    }

    private Point zoomTextPoint(int x, int y) {
        FontMetrics metric;
        if (this.localCache.font != this.localFont) {
            metric = FigureUtilities.getFontMetrics((Font)this.localFont);
            this.localCache.height = metric.getHeight() - metric.getDescent();
            this.localCache.font = this.localFont;
        }
        if (this.targetCache.font != this.graphics.getFont()) {
            metric = this.graphics.getFontMetrics();
            this.targetCache.font = this.graphics.getFont();
            this.targetCache.height = metric.getHeight() - metric.getDescent();
        }
        return new Point((int)Math.floor((double)x * this.xZoom + this.fractionalX), (int)Math.floor((double)(y + this.localCache.height - 1) * this.yZoom - (double)this.targetCache.height + 1.0 + this.fractionalY));
    }

    private static class FontHeightCache {
        private Font font;
        private int height;

        private FontHeightCache() {
        }
    }

    static class FontKey {
        private Font font;
        private int height;

        protected FontKey() {
        }

        protected FontKey(Font font, int height) {
            this.font = font;
            this.height = height;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FontKey) {
                return ((FontKey)obj).font.equals((Object)this.font) && ((FontKey)obj).height == this.height;
            }
            return false;
        }

        public int hashCode() {
            return this.font.hashCode() ^ this.height;
        }

        protected void setValues(Font newFont, int newHeight) {
            this.font = newFont;
            this.height = newHeight;
        }
    }

    protected static class State {
        private double appliedX;
        private double appliedY;
        private Font font;
        private int lineWidth;
        private double xZoom;
        private double yZoom;

        protected State() {
        }

        protected State(double xZoom, double yZoom, double x, double y, Font font, int lineWidth) {
            this.xZoom = xZoom;
            this.yZoom = yZoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
        }

        protected void setValues(double newXZoom, double newYZoom, double x, double y, Font newFont, int newLineWidth) {
            this.xZoom = newXZoom;
            this.yZoom = newYZoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = newFont;
            this.lineWidth = newLineWidth;
        }
    }
}

