/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.editparts;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.editparts.EditorDoModelEditPart;
import de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.TextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.VisibleForm;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;

public class EditorDoModelAktivator
implements ClientReceiverInterface,
ZoomListener {
    private final EditorDoModelEditPart editPart;
    private final Map<VisibleForm, List<DataDescription>> decoratedForms = new HashMap<VisibleForm, List<DataDescription>>();
    private final Map<DataDescription, ResultData> connections = new HashMap<DataDescription, ResultData>();
    private boolean zoomDecorated;

    public static Data getDatenElement(Data datenSatz, String attributPfad) {
        Data result = null;
        if (datenSatz != null && attributPfad != null && !attributPfad.isEmpty()) {
            String[] parts;
            result = datenSatz;
            String[] stringArray = parts = attributPfad.split("\\.");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String pathPart = stringArray[n2];
                if (result == null) break;
                result = result.getItem(pathPart);
                ++n2;
            }
        }
        return result;
    }

    protected EditorDoModelAktivator(EditorDoModelEditPart dobj) {
        this.editPart = dobj;
    }

    protected void activate() {
        this.organizeDecorators();
        this.connect();
        if (this.zoomDecorated) {
            this.editPart.getZoomManager().addZoomListener((ZoomListener)this);
        }
        this.updateFigures();
    }

    private DecoratorDatenSatz berechneDecoratorDaten(AttributeDecorator decorator, ResultData resultData) {
        DecoratorDatenSatz result = null;
        String valueText = null;
        if (decorator instanceof StringParameterDefinition) {
            valueText = ((StringParameterDefinition)((Object)decorator)).getString();
            if ("#NAME#".equals(valueText)) {
                valueText = ((EditorDoModel)this.editPart.getModel()).getSystemObject().getName();
            } else if ("#NAME_PID#".equals(valueText)) {
                valueText = ((EditorDoModel)this.editPart.getModel()).getSystemObject().toString();
            } else if ("#PID#".equals(valueText)) {
                valueText = ((EditorDoModel)this.editPart.getModel()).getSystemObject().getPid();
            }
        }
        if (resultData != null) {
            Data datenElement = EditorDoModelAktivator.getDatenElement(resultData.getData(), decorator.getAttributPfad());
            if (decorator instanceof StringParameterDefinition) {
                valueText = ((StringParameterDefinition)((Object)decorator)).getString();
                if ("#WERT#".equals(valueText)) {
                    valueText = datenElement != null && datenElement.isPlain() ? datenElement.asTextValue().getText() : (datenElement == null ? resultData.getDataState().toString() : "");
                } else if ("#ZEITSTEMPEL#".equals(valueText)) {
                    valueText = DateFormat.getDateTimeInstance().format(new Date(resultData.getDataTime()));
                } else if ("#ZEIT#".equals(valueText)) {
                    valueText = DateFormat.getTimeInstance().format(new Date(resultData.getDataTime()));
                } else if ("#DATUM#".equals(valueText)) {
                    valueText = DateFormat.getDateInstance().format(new Date(resultData.getDataTime()));
                }
            }
            if (decorator instanceof TextDecorator) {
                String bedingung = ((TextDecorator)((Object)decorator)).getText();
                if (bedingung.isEmpty()) {
                    if (valueText != null) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, valueText);
                    }
                } else if ("#KEINE_DATEN#".equals(bedingung)) {
                    if (resultData.getDataState().equals(DataState.NO_DATA)) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, "Keine Daten");
                    }
                } else if ("#KEINE_QUELLE#".equals(bedingung)) {
                    if (resultData.getDataState().equals(DataState.NO_SOURCE)) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, "Keine Quelle");
                    }
                } else if ("#KEINE_RECHTE#".equals(bedingung)) {
                    if (resultData.getDataState().equals(DataState.NO_RIGHTS)) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, "Keine Rechte");
                    }
                } else if ("#DATEN#".equals(bedingung)) {
                    if (resultData.getDataState().equals(DataState.DATA)) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, valueText);
                    }
                } else if (datenElement != null && datenElement.isPlain()) {
                    valueText = datenElement.asTextValue().getText();
                    if (valueText.equals(bedingung)) {
                        result = new DecoratorDatenSatz(datenElement, 1.0, valueText);
                    } else {
                        valueText = null;
                    }
                }
            } else if (decorator instanceof IntervalDecorator) {
                IntervalDecorator ivDecorator = (IntervalDecorator)((Object)decorator);
                double start = ivDecorator.getStart();
                double ende = ivDecorator.getEnd();
                Double wert = this.getDatenElementDoubleWert(datenElement);
                if (wert != null && wert >= start && wert < ende) {
                    result = new DecoratorDatenSatz(datenElement, (wert - start) * 100.0 / (ende - start), wert.toString());
                }
            }
        }
        if (result == null && valueText != null) {
            result = new DecoratorDatenSatz(null, 1.0, valueText);
        }
        return result;
    }

    private void connect() {
        if (((EditorDoModel)this.editPart.getModel()).getSystemObject() != null) {
            ClientDavInterface verbindung = RahmenwerkService.getService().getObjektFactory().getDav();
            for (DataDescription key : this.connections.keySet()) {
                verbindung.subscribeReceiver((ClientReceiverInterface)this, ((EditorDoModel)this.editPart.getModel()).getSystemObject(), key, ReceiveOptions.normal(), ReceiverRole.receiver());
            }
        }
    }

    protected void deactivate() {
        this.disconnect();
        if (this.zoomDecorated) {
            this.editPart.getZoomManager().removeZoomListener((ZoomListener)this);
        }
        for (DataDescription desc : this.connections.keySet()) {
            this.connections.put(desc, null);
        }
    }

    private void disconnect() {
        if (((EditorDoModel)this.editPart.getModel()).getSystemObject() != null) {
            ClientDavInterface verbindung = RahmenwerkService.getService().getObjektFactory().getDav();
            for (DataDescription key : this.connections.keySet()) {
                verbindung.unsubscribeReceiver((ClientReceiverInterface)this, ((EditorDoModel)this.editPart.getModel()).getSystemObject(), key);
            }
        }
    }

    private Double getDatenElementDoubleWert(Data datenElement) {
        if (datenElement == null || !datenElement.isPlain() || datenElement.toString().contains("<Undefiniert>")) {
            return null;
        }
        Number value = null;
        if (datenElement.getAttributeType() instanceof IntegerAttributeType) {
            IntegerValueRange range = ((IntegerAttributeType)datenElement.getAttributeType()).getRange();
            List states = ((IntegerAttributeType)datenElement.getAttributeType()).getStates();
            if (range == null) {
                value = datenElement.asUnscaledValue().doubleValue();
            } else {
                if (states != null) {
                    long tempValue = datenElement.asUnscaledValue().longValue();
                    for (IntegerValueState state : states) {
                        if (state.getValue() != tempValue) continue;
                        value = tempValue;
                        break;
                    }
                }
                if (value == null) {
                    value = datenElement.asScaledValue().doubleValue();
                }
            }
        } else if (datenElement.getAttributeType() instanceof DoubleAttributeType) {
            value = datenElement.asUnscaledValue().doubleValue();
        } else if (datenElement.getAttributeType() instanceof TimeAttributeType) {
            value = datenElement.asTimeValue().getMillis();
        }
        if (value != null) {
            return (double)value;
        }
        return null;
    }

    protected Map<ParameterDefinition, DecoratorDatenSatz> getValidDecorators(VisibleForm form) {
        HashMap<ParameterDefinition, DecoratorDatenSatz> result = new HashMap<ParameterDefinition, DecoratorDatenSatz>();
        EList<Decorator> decorators = form.getDecorators();
        for (Decorator decorator : decorators) {
            if (!(decorator instanceof ParameterDefinition)) continue;
            if (decorator instanceof AttributeDecorator) {
                AttributeDecorator attDec = (AttributeDecorator)decorator;
                if (((EditorDoModel)this.editPart.getModel()).getSystemObject() != null) {
                    DataDescription desc = new DataDescription(attDec.getAttributGruppe(), attDec.getAspekt());
                    ResultData resultData = this.connections.get(desc);
                    DecoratorDatenSatz datenSatz = this.berechneDecoratorDaten((AttributeDecorator)decorator, resultData);
                    if (datenSatz == null) {
                        if (decorator instanceof StringParameterDefinition) {
                            String string = ((StringParameterDefinition)((Object)decorator)).getString();
                            if ("#NAME#".equals(string)) {
                                datenSatz = new DecoratorDatenSatz(null, 1.0, ((EditorDoModel)this.editPart.getModel()).getSystemObject().getName());
                            } else if ("#NAME_PID#".equals(string)) {
                                datenSatz = new DecoratorDatenSatz(null, 1.0, ((EditorDoModel)this.editPart.getModel()).getSystemObject().toString());
                            } else if ("#PID#".equals(string)) {
                                datenSatz = new DecoratorDatenSatz(null, 1.0, ((EditorDoModel)this.editPart.getModel()).getSystemObject().getPid());
                            }
                            if (datenSatz != null) {
                                result.put((ParameterDefinition)((Object)attDec), datenSatz);
                            }
                        }
                    } else {
                        result.put((ParameterDefinition)((Object)attDec), datenSatz);
                    }
                }
            }
            if (!(decorator instanceof ZoomDecorator)) continue;
            ZoomDecorator zoomDec = (ZoomDecorator)decorator;
            Double zoom = this.getZoomInProzent();
            if (!(zoomDec.getStart() <= zoom) || !(zoomDec.getEnd() > zoom)) continue;
            result.put((ParameterDefinition)((Object)zoomDec), null);
        }
        return result;
    }

    private Double getZoomInProzent() {
        return this.editPart.getZoomManager().getZoom() * 100.0;
    }

    private void organizeDecorators() {
        for (VisibleForm form : ((EditorDoTypReferenz)((EditorDoModel)this.editPart.getModel()).getDoTyp()).getWrapped().getFormen()) {
            for (Decorator decorator : form.getDecorators()) {
                if (decorator instanceof AttributeDecorator) {
                    AttributeGroup atg = ((AttributeDecorator)decorator).getAttributGruppe();
                    Aspect asp = ((AttributeDecorator)decorator).getAspekt();
                    if (atg == null || asp == null) continue;
                    DataDescription dataDesc = new DataDescription(atg, asp);
                    this.connections.put(dataDesc, null);
                    List<DataDescription> descList = this.decoratedForms.get(form);
                    if (descList == null) {
                        descList = new ArrayList<DataDescription>();
                        this.decoratedForms.put(form, descList);
                    }
                    descList.add(dataDesc);
                    continue;
                }
                if (!(decorator instanceof ZoomDecorator)) continue;
                this.zoomDecorated = true;
            }
        }
    }

    public void update(ResultData[] results) {
        ResultData[] resultDataArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData result = resultDataArray[n2];
            this.connections.put(result.getDataDescription(), result);
            ++n2;
        }
        this.updateFigures();
    }

    private void updateFigures() {
        Display.getDefault().asyncExec(() -> this.editPart.refresh());
    }

    public void zoomChanged(double zoom) {
        this.updateFigures();
    }

    public void reset() {
        for (DataDescription desc : this.connections.keySet()) {
            this.connections.put(desc, null);
        }
        this.updateFigures();
    }
}

