/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.util.BildManager;
import de.bsvrz.buv.plugin.doeditor.DoGraphics;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.figures.VisibleFormFigure;
import de.bsvrz.buv.plugin.doeditor.model.BildForm;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

public class BildFormFigure
extends ImageFigure
implements VisibleFormFigure {
    private final BildForm bild;
    private final ResourceManager resourceManager;
    private double scale = 1.0;
    private ZoomVerhalten zoomVerhalten;
    private double currentAngle;

    public BildFormFigure(EditPartViewer viewer, BildForm bild) {
        this.resourceManager = viewer.getResourceManager();
        this.bild = bild;
        this.zoomVerhalten = this.bild.getZoomVerhalten();
    }

    @Override
    public void aktualisiereVomModel() {
        ImageDescriptor defaultDesc;
        this.zoomVerhalten = this.bild.getZoomVerhalten();
        Bild imageReferenz = this.bild.getBild();
        Image image = null;
        if (imageReferenz != null) {
            image = (Image)this.resourceManager.create((DeviceResourceDescriptor)BildManager.INSTANCE.getImageDescriptor(imageReferenz));
        }
        if (image == null && (defaultDesc = DObjPlugin.getDefault().getImageDescriptor("resources/defaultImage.png")) != null) {
            image = (Image)this.resourceManager.create((DeviceResourceDescriptor)defaultDesc);
        }
        if (image != null) {
            this.setImage(image);
            this.updateSize();
        }
        this.setLocation(this.bild.getLocation());
        this.setVisible(this.bild.isVisible());
        this.currentAngle = this.bild.getAngle();
        this.updateSize();
    }

    @Override
    public void decorate(ParameterDefinition decorator, DecoratorDatenSatz datenSatz) {
        if (decorator instanceof SichtbarkeitParameterDefinition) {
            SichtbarkeitParameterDefinition sichtbarkeitDefinition = (SichtbarkeitParameterDefinition)decorator;
            this.setVisible(sichtbarkeitDefinition.isSichtbar());
        } else if (decorator instanceof ZoomVerhaltenParameterDefinition) {
            ZoomVerhaltenParameterDefinition zoomVerhaltenDefinition = (ZoomVerhaltenParameterDefinition)decorator;
            this.zoomVerhalten = zoomVerhaltenDefinition.getZoomVerhalten();
            this.setScale(this.scale);
        }
    }

    public double getScale() {
        return this.scale;
    }

    protected void paintFigure(Graphics gr) {
        DoGraphics graphics = new DoGraphics(gr);
        if (this.currentAngle != 0.0) {
            graphics.translate(this.getBounds().getCenter());
            graphics.rotate((float)this.currentAngle);
            graphics.translate(this.getBounds().getCenter().getNegated());
        }
        if (this.scale != 1.0) {
            graphics.translate(this.getBounds().getLocation());
            switch (this.zoomVerhalten) {
                case FIX: {
                    graphics.scale((float)(1.0 / this.scale), (float)(1.0 / this.scale));
                    break;
                }
                case HORIZONTAL: {
                    graphics.scale(1.0f, (float)(1.0 / this.scale));
                    break;
                }
                case VERTIKAL: {
                    graphics.scale((float)(1.0 / this.scale), 1.0f);
                    break;
                }
            }
            graphics.translate(this.getBounds().getLocation().getNegated());
        }
        graphics.drawImage(this.getImage(), this.bild.getLocation().x, this.bild.getLocation().y);
        graphics.dispose();
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateSize();
    }

    private void updateSize() {
        Image image = this.getImage();
        if (image != null) {
            Rectangle newBounds = DoEditorUtil.getCenterRotatedBounds(new Rectangle(this.bild.getLocation().x, this.bild.getLocation().y, image.getImageData().width, image.getImageData().height), this.currentAngle);
            switch (this.zoomVerhalten) {
                case FIX: {
                    newBounds.height = (int)((double)newBounds.height / this.scale);
                    newBounds.width = (int)((double)newBounds.width / this.scale);
                    break;
                }
                case VERTIKAL: {
                    newBounds.width = (int)((double)newBounds.width / this.scale);
                    break;
                }
                case HORIZONTAL: {
                    newBounds.height = (int)((double)newBounds.height / this.scale);
                    break;
                }
            }
            this.setBounds(newBounds);
        }
    }
}

