/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.decorator.DrehungFigure;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class EditorDoModelFigure
extends Figure
implements DoFigure,
DrehungFigure,
ScalableFigure {
    private double scale = 1.0;
    private float winkel;
    private Dimension size;
    private Point locOffset = new Point();
    private Point hotspot = new Point();
    private double vonZoom;
    private double bisZoom = Double.MAX_VALUE;
    private double zoom = 1.0;

    protected boolean useLocalCoordinates() {
        return true;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateBounds();
    }

    @Override
    public float getDrehwinkel() {
        return this.winkel;
    }

    @Override
    public void setDrehwinkel(float drehwinkel) {
        this.winkel = drehwinkel;
        this.updateBounds();
    }

    @Override
    public Point getHotspot() {
        return this.hotspot;
    }

    @Override
    public void setHotspot(Point hotspot) {
        this.hotspot = hotspot;
        this.updateBounds();
    }

    private void updateBounds() {
        Point calculatedLocation = this.hotspot.getCopy().translate(this.locOffset.getNegated()).scale(1.0 / this.scale);
        this.setLocation(calculatedLocation);
        Rectangle originalBounds = new Rectangle(calculatedLocation, this.size);
        Point drehPunkt = this.hotspot.getCopy().translate(this.locOffset.getNegated());
        Rectangle rotatedBounds = DoEditorUtil.getRotatedBounds(originalBounds.scale(this.scale), this.winkel, drehPunkt);
        this.setBounds(rotatedBounds);
    }

    @Override
    public void handleZoomChanged(double newZoom) {
        this.zoom = newZoom;
        this.updateVisibility();
    }

    @Override
    public void setSichtbareZoomStufe(double newVonZoom, double newBisZoom) {
        if (this.vonZoom == newVonZoom && this.bisZoom == newBisZoom) {
            return;
        }
        this.vonZoom = newVonZoom;
        this.bisZoom = newBisZoom;
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.zoom >= this.vonZoom && this.zoom <= this.bisZoom) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        Rectangle rotatedBounds = this.getBounds().getCopy();
        Rectangle clipRect = new Rectangle(this.hotspot, this.size).getUnion(rotatedBounds);
        graphics.setClip(clipRect.intersect(graphics.getClip(new Rectangle())));
        if (this.winkel != 0.0f) {
            Point rotationPt = this.hotspot.getCopy().translate(this.locOffset.getNegated());
            graphics.translate(rotationPt);
            graphics.rotate(this.winkel);
            graphics.translate(rotationPt.getNegated());
            graphics.translate(this.hotspot.x - this.getBounds().x, this.hotspot.y - this.getBounds().y);
        }
        if (this.scale != 1.0) {
            graphics.translate(this.getLocation());
            graphics.scale(this.scale);
            graphics.translate(this.getLocation().getNegated());
        }
        super.paint(graphics);
        graphics.popState();
    }

    public void setDimension(Dimension newSize) {
        this.size = newSize;
        this.updateBounds();
    }

    public void setLocOffset(Point locOffset) {
        this.locOffset = locOffset == null ? new Point() : locOffset;
        this.updateBounds();
    }
}

