/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;
import de.bsvrz.buv.plugin.doeditor.DoGraphics;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.figures.VisibleFormFigure;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.EllipseForm;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import de.bsvrz.buv.plugin.doeditor.util.PatternRegistry;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;

public class EllipseFormFigure
extends Ellipse
implements VisibleFormFigure {
    private final EllipseForm ellipse;
    private final ResourceManager resourceManager;
    private final PatternRegistry patterns;
    private double scale = 1.0;
    private ZoomVerhalten zoomVerhalten;
    private double currentAngle;

    public EllipseFormFigure(EditPartViewer viewer, EllipseForm ellipse) {
        this.resourceManager = viewer.getResourceManager();
        this.patterns = PatternRegistry.getRegistry(viewer);
        this.ellipse = ellipse;
        this.currentAngle = ellipse.getAngle();
        this.zoomVerhalten = ellipse.getZoomVerhalten();
    }

    @Override
    public void aktualisiereVomModel() {
        this.zoomVerhalten = this.ellipse.getZoomVerhalten();
        this.setLocation(this.ellipse.getLocation());
        this.currentAngle = this.ellipse.getAngle();
        this.updateSize();
        this.setForegroundColor(this.resourceManager.createColor(this.ellipse.getForegroundColor().getRgb()));
        this.setVisible(this.ellipse.isVisible());
        ELineAttributes lineAttributes = this.ellipse.getLineAttributes();
        this.setLineWidthFloat(lineAttributes.getWidth());
        this.setLineStyle(lineAttributes.getStyle());
        this.setBackgroundColor(this.resourceManager.createColor(this.ellipse.getBackgroundColor().getRgb()));
        this.setFill(this.ellipse.isFilled());
    }

    private void updateSize() {
        Rectangle newBounds = DoEditorUtil.getCenterRotatedBounds(this.ellipse.getBounds(), this.currentAngle);
        switch (this.zoomVerhalten) {
            case FIX: {
                newBounds.height = (int)((double)newBounds.height / this.scale);
                newBounds.width = (int)((double)newBounds.width / this.scale);
                break;
            }
            case VERTIKAL: {
                newBounds.width = (int)((double)newBounds.width / this.scale);
                break;
            }
            case HORIZONTAL: {
                newBounds.height = (int)((double)newBounds.height / this.scale);
                break;
            }
        }
        this.setBounds(newBounds);
    }

    @Override
    public void decorate(ParameterDefinition decorator, DecoratorDatenSatz datenSatz) {
        if (decorator instanceof BackgroundParameterDefinition) {
            EColor startColor = ((BackgroundParameterDefinition)decorator).getStartColor();
            EColor endColor = ((BackgroundParameterDefinition)decorator).getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setBackgroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof ForegroundParameterDefinition) {
            EColor startColor = ((ForegroundParameterDefinition)decorator).getStartColor();
            EColor endColor = ((ForegroundParameterDefinition)decorator).getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setForegroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof DrehwinkelParameterDefinition) {
            float winkel = ((DrehwinkelParameterDefinition)decorator).getStartWinkel();
            Float endWinkel = ((DrehwinkelParameterDefinition)decorator).getEndWinkel();
            if (endWinkel != null) {
                winkel = (float)((double)winkel + (double)(endWinkel.floatValue() - winkel) * datenSatz.getRelativerWert() / 100.0);
            }
            this.currentAngle = winkel;
            this.updateSize();
        } else if (decorator instanceof LineAttributeParameterDefinition) {
            ELineAttributes att = ((LineAttributeParameterDefinition)decorator).getLineAttributes();
            if (att != null) {
                this.setLineWidthFloat(att.getWidth());
                this.setLineStyle(att.getStyle());
            }
        } else if (decorator instanceof SichtbarkeitParameterDefinition) {
            this.setVisible(((SichtbarkeitParameterDefinition)decorator).isSichtbar());
        } else if (decorator instanceof ZoomVerhaltenParameterDefinition) {
            this.zoomVerhalten = ((ZoomVerhaltenParameterDefinition)decorator).getZoomVerhalten();
            this.setScale(this.scale);
        }
    }

    protected void fillShape(Graphics graphics) {
        Pattern pattern = this.patterns.getPattern(this.ellipse.getBackgroundPattern(), this.getForegroundColor().getRGB(), this.getBackgroundColor().getRGB());
        if (pattern != null) {
            graphics.setBackgroundPattern(pattern);
        }
        graphics.fillOval(this.ellipse.getBounds());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateSize();
    }

    public void paintFigure(Graphics gr) {
        DoGraphics graphics = new DoGraphics(gr);
        if (this.currentAngle != 0.0) {
            graphics.translate(this.getBounds().getCenter());
            graphics.rotate((float)this.currentAngle);
            graphics.translate(this.getBounds().getCenter().getNegated());
        }
        if (this.scale != 1.0) {
            graphics.translate(this.getBounds().getLocation());
            switch (this.zoomVerhalten) {
                case FIX: {
                    graphics.scale((float)(1.0 / this.scale), (float)(1.0 / this.scale));
                    break;
                }
                case HORIZONTAL: {
                    graphics.scale(1.0f, (float)(1.0 / this.scale));
                    break;
                }
                case VERTIKAL: {
                    graphics.scale((float)(1.0 / this.scale), 1.0f);
                    break;
                }
            }
            graphics.translate(this.getBounds().getLocation().getNegated());
        }
        super.paintFigure((Graphics)graphics);
        graphics.dispose();
    }

    protected void outlineShape(Graphics graphics) {
        double lineWidthFloat = (double)this.getLineWidthFloat() / this.scale;
        if (lineWidthFloat > 0.0) {
            double lineInset = Math.max(1.0, lineWidthFloat) / 2.0;
            int inset1 = (int)Math.floor(lineInset);
            int inset2 = (int)Math.ceil(lineInset);
            Rectangle r = Rectangle.SINGLETON.setBounds(this.ellipse.getBounds());
            r.x += inset1;
            r.y += inset1;
            r.width -= inset1 + inset2;
            r.height -= inset1 + inset2;
            graphics.setLineWidthFloat((float)lineWidthFloat);
            graphics.drawOval(r);
        }
    }
}

