/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.figures.VisibleFormFigure;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.PolygonForm;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import de.bsvrz.buv.plugin.doeditor.util.PatternRegistry;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;

public class PolygonFormFigure
extends Polygon
implements VisibleFormFigure {
    private final PolygonForm polygon;
    private final ResourceManager resourceManager;
    private final PatternRegistry patterns;
    private double scale = 1.0;
    private ZoomVerhalten zoomVerhalten;
    private float currentAngle;

    public PolygonFormFigure(EditPartViewer viewer, PolygonForm polygon) {
        this.resourceManager = viewer.getResourceManager();
        this.patterns = PatternRegistry.getRegistry(viewer);
        this.polygon = polygon;
        this.zoomVerhalten = polygon.getZoomVerhalten();
    }

    @Override
    public void aktualisiereVomModel() {
        this.zoomVerhalten = this.polygon.getZoomVerhalten();
        this.setLocation(this.polygon.getLocation());
        this.polygon.getSize();
        this.setForegroundColor(this.resourceManager.createColor(this.polygon.getForegroundColor().getRgb()));
        this.setAngle(Double.valueOf(this.polygon.getAngle()).floatValue());
        this.setVisible(this.polygon.isVisible());
        ELineAttributes lineAttributes = this.polygon.getLineAttributes();
        this.setLineWidthFloat(lineAttributes.getWidth());
        this.setLineStyle(lineAttributes.getStyle());
        this.setPoints(this.polygon.getPoints());
        this.setBounds(this.polygon.getBounds());
        this.setFill(this.polygon.isFilled());
        this.setBackgroundColor(this.resourceManager.createColor(this.polygon.getBackgroundColor().getRgb()));
        this.setScale(this.scale);
    }

    private void setAngle(float angle) {
        this.currentAngle = angle;
    }

    @Override
    public void decorate(ParameterDefinition decorator, DecoratorDatenSatz datenSatz) {
        if (decorator instanceof BackgroundParameterDefinition) {
            EColor startColor = ((BackgroundParameterDefinition)decorator).getStartColor();
            EColor endColor = ((BackgroundParameterDefinition)decorator).getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setBackgroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof ForegroundParameterDefinition) {
            EColor startColor = ((ForegroundParameterDefinition)decorator).getStartColor();
            EColor endColor = ((ForegroundParameterDefinition)decorator).getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setForegroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof DrehwinkelParameterDefinition) {
            DObjPlugin.getDefault().getLog().warn("Die \u00c4nderung des Drehwinkels wird f\u00fcr Polygone nicht unterst\u00fctzt!");
        } else if (decorator instanceof LineAttributeParameterDefinition) {
            ELineAttributes att = ((LineAttributeParameterDefinition)decorator).getLineAttributes();
            if (att != null) {
                this.setLineWidthFloat(att.getWidth());
                this.setLineStyle(att.getStyle());
            }
        } else if (decorator instanceof SichtbarkeitParameterDefinition) {
            this.setVisible(((SichtbarkeitParameterDefinition)decorator).isSichtbar());
        } else if (decorator instanceof ZoomVerhaltenParameterDefinition) {
            this.zoomVerhalten = ((ZoomVerhaltenParameterDefinition)decorator).getZoomVerhalten();
            this.setScale(this.scale);
        }
    }

    protected void fillShape(Graphics graphics) {
        Pattern pattern = this.patterns.getPattern(this.polygon.getBackgroundPattern(), this.getForegroundColor().getRGB(), this.getBackgroundColor().getRGB());
        if (pattern != null) {
            graphics.setBackgroundPattern(pattern);
        }
        super.fillShape(graphics);
    }

    public double getScale() {
        return this.scale;
    }

    private void performHorizontalScale(PointList points, double value) {
        int idx = 0;
        while (idx < points.size()) {
            Point point = points.getPoint(idx);
            point.y = (int)((double)point.y * value);
            points.setPoint(point, idx);
            ++idx;
        }
    }

    private void performVertikalScale(PointList points, double value) {
        int idx = 0;
        while (idx < points.size()) {
            Point point = points.getPoint(idx);
            point.x = (int)((double)point.x * value);
            points.setPoint(point, idx);
            ++idx;
        }
    }

    public void setScale(double scale) {
        this.scale = scale;
        PointList points = new PointList();
        points.addAll(this.polygon.getPoints());
        switch (this.zoomVerhalten) {
            case FIX: {
                points.performScale(1.0 / scale);
                this.setPoints(points);
                break;
            }
            case VERTIKAL: {
                this.performVertikalScale(points, 1.0 / scale);
                this.setPoints(points);
                break;
            }
            case HORIZONTAL: {
                this.performHorizontalScale(points, 1.0 / scale);
                this.setPoints(points);
                break;
            }
        }
    }

    public void paintFigure(Graphics gr) {
        if (this.currentAngle != 0.0f) {
            this.setPoints(DoEditorUtil.getRotatedPoints(this.polygon.getPoints(), this.currentAngle, null));
        }
        super.paintFigure(gr);
    }
}

