/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.figures.VisibleFormFigure;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.PolylineForm;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;

public class PolylineFormFigure
extends Polyline
implements VisibleFormFigure {
    private final PolylineForm polyline;
    private final ResourceManager resourceManager;
    private double scale = 1.0;
    private ZoomVerhalten zoomVerhalten;
    private float currentAngle;

    public PolylineFormFigure(EditPartViewer viewer, PolylineForm polyline) {
        this.resourceManager = viewer.getResourceManager();
        this.polyline = polyline;
        this.zoomVerhalten = polyline.getZoomVerhalten();
    }

    private void setAngle(float angle) {
        this.currentAngle = angle;
    }

    @Override
    public void aktualisiereVomModel() {
        this.zoomVerhalten = this.polyline.getZoomVerhalten();
        this.setLocation(this.polyline.getLocation());
        this.setForegroundColor(this.resourceManager.createColor(this.polyline.getForegroundColor().getRgb()));
        this.setAngle(Double.valueOf(this.polyline.getAngle()).floatValue());
        this.setVisible(this.polyline.isVisible());
        ELineAttributes lineAttributes = this.polyline.getLineAttributes();
        this.setLineWidthFloat(lineAttributes.getWidth());
        this.setLineStyle(lineAttributes.getStyle());
        this.setPoints(this.polyline.getPoints());
        this.setBounds(this.polyline.getBounds());
        this.setScale(this.scale);
    }

    @Override
    public void decorate(ParameterDefinition decorator, DecoratorDatenSatz datenSatz) {
        if (decorator instanceof ForegroundParameterDefinition) {
            EColor startColor = ((ForegroundParameterDefinition)decorator).getStartColor();
            EColor endColor = ((ForegroundParameterDefinition)decorator).getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setForegroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof DrehwinkelParameterDefinition) {
            DObjPlugin.getDefault().getLog().warn("Die \u00c4nderung des Drehwinkels wird f\u00fcr Polylinien nicht unterst\u00fctzt!");
        } else if (decorator instanceof LineAttributeParameterDefinition) {
            ELineAttributes att = ((LineAttributeParameterDefinition)decorator).getLineAttributes();
            if (att != null) {
                this.setLineWidthFloat(att.getWidth());
                this.setLineStyle(att.getStyle());
            }
        } else if (decorator instanceof SichtbarkeitParameterDefinition) {
            this.setVisible(((SichtbarkeitParameterDefinition)decorator).isSichtbar());
        } else if (decorator instanceof ZoomVerhaltenParameterDefinition) {
            this.zoomVerhalten = ((ZoomVerhaltenParameterDefinition)decorator).getZoomVerhalten();
            this.setScale(this.scale);
        }
    }

    public double getScale() {
        return this.scale;
    }

    private void performHorizontalScale(PointList points, double value) {
        int idx = 0;
        while (idx < points.size()) {
            Point point = points.getPoint(idx);
            point.y = (int)((double)point.y * value);
            ++idx;
        }
    }

    private void performVertikalScale(PointList points, double value) {
        int idx = 0;
        while (idx < points.size()) {
            Point point = points.getPoint(idx);
            point.x = (int)((double)point.x * value);
            ++idx;
        }
    }

    public void setScale(double scale) {
        this.scale = scale;
        PointList points = new PointList();
        points.addAll(this.polyline.getPoints());
        switch (this.zoomVerhalten) {
            case FIX: {
                points.performScale(1.0 / scale);
                this.setPoints(points);
                break;
            }
            case VERTIKAL: {
                this.performVertikalScale(points, 1.0 / scale);
                this.setPoints(points);
                break;
            }
            case HORIZONTAL: {
                this.performHorizontalScale(points, 1.0 / scale);
                this.setPoints(points);
                break;
            }
        }
    }

    public void paintFigure(Graphics gr) {
        if (this.currentAngle != 0.0f) {
            this.setPoints(DoEditorUtil.getRotatedPoints(this.polyline.getPoints(), this.currentAngle, null));
        }
        super.paintFigure(gr);
    }
}

